/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator;

import java.util.Objects;

public final class SourceLocation {
    private final String filename;
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;
    private final String sourceLine;

    private SourceLocation(Builder builder) {
        this.filename = Objects.requireNonNull(builder.filename, "[" + this.getClass().getName() + "] filename must not be null");
        this.startLine = builder.startLine;
        this.startColumn = builder.startColumn;
        this.endLine = builder.endLine;
        this.endColumn = builder.endColumn;
        this.sourceLine = builder.sourceLine;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    public boolean isMultiLine() {
        return this.startLine != this.endLine;
    }

    public String formatLocation() {
        if (this.isMultiLine()) {
            return String.format("%s:%d-%d", this.filename, this.startLine, this.endLine);
        }
        if (this.startColumn > 1 && this.endColumn > 1 && this.startColumn != this.endColumn) {
            return String.format("%s:%d:%d-%d", this.filename, this.startLine, this.startColumn, this.endColumn);
        }
        if (this.startColumn > 1) {
            return String.format("%s:%d:%d", this.filename, this.startLine, this.startColumn);
        }
        return String.format("%s:%d", this.filename, this.startLine);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.startLine == that.startLine && this.startColumn == that.startColumn && this.endLine == that.endLine && this.endColumn == that.endColumn && Objects.equals(this.filename, that.filename) && Objects.equals(this.sourceLine, that.sourceLine);
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.startLine, this.startColumn, this.endLine, this.endColumn, this.sourceLine);
    }

    public String toString() {
        return this.formatLocation();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String filename;
        private int startLine = 1;
        private int startColumn = 1;
        private int endLine = 1;
        private int endColumn = 1;
        private String sourceLine;

        private Builder() {
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        public Builder startColumn(int startColumn) {
            this.startColumn = startColumn;
            return this;
        }

        public Builder endLine(int endLine) {
            this.endLine = endLine;
            return this;
        }

        public Builder endColumn(int endColumn) {
            this.endColumn = endColumn;
            return this;
        }

        public Builder line(int line) {
            this.startLine = line;
            this.endLine = line;
            return this;
        }

        public Builder columns(int start, int end) {
            this.startColumn = start;
            this.endColumn = end;
            return this;
        }

        public Builder sourceLine(String sourceLine) {
            this.sourceLine = sourceLine;
            return this;
        }

        public SourceLocation build() {
            return new SourceLocation(this);
        }
    }
}

