/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Suggestion {
    private final String description;
    private final String fixedValue;
    private final String explanation;
    private final boolean preferred;
    private final List<String> examples;
    private final boolean autoFixable;

    private Suggestion(Builder builder) {
        this.description = Objects.requireNonNull(builder.description, "[" + this.getClass().getName() + "] description must not be null");
        this.fixedValue = builder.fixedValue;
        this.explanation = builder.explanation;
        this.preferred = builder.preferred;
        this.examples = new ArrayList<String>(builder.examples);
        this.autoFixable = builder.autoFixable;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public boolean hasFixedValue() {
        return this.fixedValue != null && !this.fixedValue.isEmpty();
    }

    public String getExplanation() {
        return this.explanation;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public List<String> getExamples() {
        return new ArrayList<String>(this.examples);
    }

    public boolean hasExamples() {
        return !this.examples.isEmpty();
    }

    public boolean isAutoFixable() {
        return this.autoFixable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Suggestion that = (Suggestion)o;
        return this.preferred == that.preferred && this.autoFixable == that.autoFixable && Objects.equals(this.description, that.description) && Objects.equals(this.fixedValue, that.fixedValue) && Objects.equals(this.explanation, that.explanation) && Objects.equals(this.examples, that.examples);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.fixedValue, this.explanation, this.preferred, this.examples, this.autoFixable);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String fixedValue;
        private String explanation;
        private boolean preferred;
        private final List<String> examples = new ArrayList<String>();
        private boolean autoFixable;

        private Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder fixedValue(String fixedValue) {
            this.fixedValue = fixedValue;
            return this;
        }

        public Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public Builder preferred(boolean preferred) {
            this.preferred = preferred;
            return this;
        }

        public Builder addExample(String example) {
            this.examples.add(example);
            return this;
        }

        public Builder examples(List<String> examples) {
            this.examples.clear();
            if (examples != null) {
                this.examples.addAll(examples);
            }
            return this;
        }

        public Builder autoFixable(boolean autoFixable) {
            this.autoFixable = autoFixable;
            return this;
        }

        public Suggestion build() {
            return new Suggestion(this);
        }
    }
}

