/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.validator.ErrorType;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.Suggestion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ValidationMessage {
    private final Severity severity;
    private final String ruleId;
    private final String message;
    private final SourceLocation location;
    private final String attributeName;
    private final String actualValue;
    private final String expectedValue;
    private final ErrorType errorType;
    private final String missingValueHint;
    private final List<Suggestion> suggestions;
    private final List<String> contextLines;
    private final Throwable cause;

    private ValidationMessage(Builder builder) {
        this.severity = Objects.requireNonNull(builder.severity, "[" + this.getClass().getName() + "] severity must not be null");
        this.ruleId = Objects.requireNonNull(builder.ruleId, "[" + this.getClass().getName() + "] ruleId must not be null");
        this.message = Objects.requireNonNull(builder.message, "[" + this.getClass().getName() + "] message must not be null");
        this.location = Objects.requireNonNull(builder.location, "[" + this.getClass().getName() + "] location must not be null");
        this.attributeName = builder.attributeName;
        this.actualValue = builder.actualValue;
        this.expectedValue = builder.expectedValue;
        this.errorType = builder.errorType != null ? builder.errorType : ErrorType.GENERIC;
        this.missingValueHint = builder.missingValueHint;
        this.suggestions = new ArrayList<Suggestion>(builder.suggestions);
        this.contextLines = new ArrayList<String>(builder.contextLines);
        this.cause = builder.cause;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getMessage() {
        return this.message;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public Optional<String> getAttributeName() {
        return Optional.ofNullable(this.attributeName);
    }

    public Optional<String> getActualValue() {
        return Optional.ofNullable(this.actualValue);
    }

    public Optional<String> getExpectedValue() {
        return Optional.ofNullable(this.expectedValue);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getMissingValueHint() {
        return this.missingValueHint;
    }

    public List<Suggestion> getSuggestions() {
        return new ArrayList<Suggestion>(this.suggestions);
    }

    public boolean hasSuggestions() {
        return !this.suggestions.isEmpty();
    }

    public boolean hasAutoFixableSuggestions() {
        return this.suggestions.stream().anyMatch(Suggestion::isAutoFixable);
    }

    public List<String> getContextLines() {
        return new ArrayList<String>(this.contextLines);
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.location.formatLocation()).append(": [").append((Object)this.severity).append("] ").append(this.message);
        if (this.actualValue != null || this.expectedValue != null) {
            sb.append("\n");
            if (this.actualValue != null) {
                sb.append("  Found: \"").append(this.actualValue).append("\"");
            }
            if (this.expectedValue != null) {
                if (this.actualValue != null) {
                    sb.append("\n");
                }
                sb.append("  Expected: ").append(this.expectedValue);
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMessage that = (ValidationMessage)o;
        return this.severity == that.severity && Objects.equals(this.ruleId, that.ruleId) && Objects.equals(this.message, that.message) && Objects.equals(this.location, that.location) && Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.actualValue, that.actualValue) && Objects.equals(this.expectedValue, that.expectedValue) && this.errorType == that.errorType && Objects.equals(this.missingValueHint, that.missingValueHint) && Objects.equals(this.suggestions, that.suggestions) && Objects.equals(this.contextLines, that.contextLines) && Objects.equals(this.cause, that.cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.ruleId, this.message, this.location, this.attributeName, this.actualValue, this.expectedValue, this.errorType, this.missingValueHint, this.suggestions, this.contextLines, this.cause});
    }

    public String toString() {
        return this.format();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Severity severity;
        private String ruleId;
        private String message;
        private SourceLocation location;
        private String attributeName;
        private String actualValue;
        private String expectedValue;
        private ErrorType errorType;
        private String missingValueHint;
        private final List<Suggestion> suggestions = new ArrayList<Suggestion>();
        private final List<String> contextLines = new ArrayList<String>();
        private Throwable cause;

        private Builder() {
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder location(SourceLocation location) {
            this.location = location;
            return this;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public Builder actualValue(String actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public Builder expectedValue(String expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public Builder errorType(ErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder missingValueHint(String missingValueHint) {
            this.missingValueHint = missingValueHint;
            return this;
        }

        public Builder addSuggestion(Suggestion suggestion) {
            if (suggestion != null) {
                this.suggestions.add(suggestion);
            }
            return this;
        }

        public Builder suggestions(List<Suggestion> suggestions) {
            this.suggestions.clear();
            if (suggestions != null) {
                this.suggestions.addAll(suggestions);
            }
            return this;
        }

        public Builder addContextLine(String line) {
            if (line != null) {
                this.contextLines.add(line);
            }
            return this;
        }

        public Builder contextLines(List<String> contextLines) {
            this.contextLines.clear();
            if (contextLines != null) {
                this.contextLines.addAll(contextLines);
            }
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public ValidationMessage build() {
            return new ValidationMessage(this);
        }
    }
}

