/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.BlockTypeValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.asciidoctor.ast.StructuralNode;

public abstract class AbstractBlockValidator<T extends Block>
implements BlockTypeValidator {
    protected abstract Class<T> getBlockConfigClass();

    protected abstract List<ValidationMessage> performSpecificValidations(StructuralNode var1, T var2, BlockValidationContext var3);

    @Override
    public final List<ValidationMessage> validate(StructuralNode node, Block config, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (!this.getBlockConfigClass().isInstance(config)) {
            return messages;
        }
        Block typedConfig = (Block)this.getBlockConfigClass().cast(config);
        messages.addAll(this.performSpecificValidations(node, typedConfig, context));
        return messages;
    }

    protected String getBlockContent(StructuralNode node) {
        if (node.getContent() instanceof String) {
            return (String)node.getContent();
        }
        if (node.getBlocks() != null && !node.getBlocks().isEmpty()) {
            StringBuilder content = new StringBuilder();
            for (Object block : node.getBlocks()) {
                StructuralNode childNode;
                if (!(block instanceof StructuralNode) || !((childNode = (StructuralNode)block).getContent() instanceof String)) continue;
                content.append(childNode.getContent()).append("\n");
            }
            return content.toString().trim();
        }
        return "";
    }

    protected int countLines(String content) {
        if (content == null || content.isEmpty()) {
            return 0;
        }
        return content.split("\n").length;
    }

    protected Severity resolveSeverity(Severity specific, Severity fallback) {
        return specific != null ? specific : fallback;
    }

    protected ValidationMessage createRequiredFieldMessage(String fieldName, Severity severity, BlockValidationContext context, StructuralNode node) {
        return ValidationMessage.builder().severity(severity).ruleId(this.getSupportedType().toValue() + "." + fieldName + ".required").location(context.createLocation(node)).message("Literal block must have a " + fieldName).actualValue("No " + fieldName).expectedValue(fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1) + " required").build();
    }

    protected ValidationMessage createPatternViolationMessage(String fieldName, String value, String pattern, Severity severity, BlockValidationContext context, StructuralNode node) {
        return ValidationMessage.builder().severity(severity).ruleId(this.getSupportedType().toValue() + "." + fieldName + ".pattern").location(context.createLocation(node)).message(fieldName + " does not match pattern: " + pattern + ". Actual: " + (value != null ? value : "null")).build();
    }

    protected ValidationMessage createLengthViolationMessage(String fieldName, int actualLength, Integer minLength, Integer maxLength, Severity severity, BlockValidationContext context, StructuralNode node) {
        String expectedValue;
        String ruleIdSuffix;
        StringBuilder message = new StringBuilder(fieldName);
        String actualValue = actualLength + " characters";
        if (minLength != null && actualLength < minLength) {
            message.append(" is too short");
            ruleIdSuffix = "minLength";
            expectedValue = "At least " + minLength + " characters";
        } else if (maxLength != null && actualLength > maxLength) {
            message.append(" is too long");
            ruleIdSuffix = "maxLength";
            expectedValue = "At most " + maxLength + " characters";
        } else {
            return null;
        }
        return ValidationMessage.builder().severity(severity).ruleId(this.getSupportedType().toValue() + "." + fieldName + "." + ruleIdSuffix).location(context.createLocation(node)).message(message.toString()).actualValue(actualValue).expectedValue(expectedValue).build();
    }

    protected ValidationMessage validateRequired(String value, String fieldName, boolean required, Severity severity, BlockValidationContext context, StructuralNode node) {
        if (required && (value == null || value.trim().isEmpty())) {
            return this.createRequiredFieldMessage(fieldName, severity, context, node);
        }
        return null;
    }

    protected ValidationMessage validatePattern(String value, String patternStr, String fieldName, Severity severity, BlockValidationContext context, StructuralNode node) {
        if (value != null && patternStr != null) {
            try {
                Pattern pattern = Pattern.compile(patternStr);
                if (!pattern.matcher(value).matches()) {
                    return this.createPatternViolationMessage(fieldName, value, patternStr, severity, context, node);
                }
            }
            catch (PatternSyntaxException e) {
                return ValidationMessage.builder().severity(Severity.ERROR).ruleId(this.getSupportedType().toValue() + "." + fieldName + ".pattern.invalid").location(context.createLocation(node)).message("Invalid pattern for " + fieldName + ": " + e.getMessage()).build();
            }
        }
        return null;
    }

    protected ValidationMessage validateLength(String value, Integer minLength, Integer maxLength, String fieldName, Severity severity, BlockValidationContext context, StructuralNode node) {
        if (value != null && (minLength != null || maxLength != null)) {
            int length = value.length();
            if (minLength != null && length < minLength || maxLength != null && length > maxLength) {
                return this.createLengthViolationMessage(fieldName, length, minLength, maxLength, severity, context, node);
            }
        }
        return null;
    }

    protected ValidationMessage validateMinMax(int value, Integer min, Integer max, String fieldName, Severity severity, BlockValidationContext context, StructuralNode node) {
        if (min != null && value < min || max != null && value > max) {
            String expectedValue;
            String actualValue;
            String ruleIdSuffix;
            String unit;
            StringBuilder message = new StringBuilder(fieldName);
            boolean isLineCount = fieldName.toLowerCase().contains("line");
            String string = unit = isLineCount ? " lines" : "";
            if (min != null && value < min) {
                message.append(" is too small");
                ruleIdSuffix = "min";
                actualValue = value + unit;
                expectedValue = "At least " + min + unit;
            } else if (max != null && value > max) {
                message.append(" is too large");
                ruleIdSuffix = "max";
                actualValue = value + unit;
                expectedValue = "At most " + max + unit;
            } else {
                return null;
            }
            String ruleIdBase = isLineCount ? this.getSupportedType().toValue() + ".lines" : this.getSupportedType().toValue() + "." + fieldName.toLowerCase().replace(" ", "");
            return ValidationMessage.builder().severity(severity).ruleId(ruleIdBase + "." + ruleIdSuffix).location(context.createLocation(node)).message(message.toString()).actualValue(actualValue).expectedValue(expectedValue).build();
        }
        return null;
    }

    protected void addIfNotNull(List<ValidationMessage> messages, ValidationMessage message) {
        if (message != null) {
            messages.add(message);
        }
    }
}

