/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AdmonitionBlock;
import com.dataliquid.asciidoc.linter.config.rule.LineConfig;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class AdmonitionBlockValidator
extends AbstractBlockValidator<AdmonitionBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.ADMONITION;
    }

    @Override
    protected Class<AdmonitionBlock> getBlockConfigClass() {
        return AdmonitionBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, AdmonitionBlock admonitionConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String admonitionType = this.getAdmonitionType(block);
        String title = block.getTitle();
        String content = this.getBlockContent(block);
        boolean hasIcon = this.hasIcon(block);
        if (admonitionConfig.getTypeConfig() != null) {
            this.validateType(admonitionType, admonitionConfig.getTypeConfig(), admonitionConfig, context, block, messages);
        }
        if (admonitionConfig.getTitle() != null) {
            this.validateTitle(title, admonitionConfig.getTitle(), admonitionConfig, context, block, messages);
        }
        if (admonitionConfig.getContent() != null) {
            this.validateContent(content, admonitionConfig.getContent(), admonitionConfig, context, block, messages);
        }
        if (admonitionConfig.getIcon() != null) {
            this.validateIcon(hasIcon, admonitionConfig.getIcon(), admonitionConfig, context, block, messages);
        }
        return messages;
    }

    private String getAdmonitionType(StructuralNode block) {
        String style = block.getStyle();
        if (style != null) {
            return style.toUpperCase();
        }
        Object role = block.getAttribute((Object)"role");
        if (role != null) {
            return role.toString().toUpperCase();
        }
        return null;
    }

    private boolean hasIcon(StructuralNode block) {
        Object docIcons = block.getDocument().getAttribute((Object)"icons");
        if (docIcons != null && "font".equals(docIcons.toString())) {
            return true;
        }
        Object blockIcon = block.getAttribute((Object)"icon");
        return blockIcon != null && !"none".equals(blockIcon.toString());
    }

    private void validateType(String admonitionType, AdmonitionBlock.TypeConfig config, AdmonitionBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (admonitionType == null || admonitionType.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.type.required").location(context.createLocation(block)).message("Admonition block must have a type").actualValue("No type").expectedValue("Type required").build());
            return;
        }
        if (admonitionType != null && config.getAllowed() != null && !config.getAllowed().isEmpty() && !config.getAllowed().contains(admonitionType)) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.type.allowed").location(context.createLocation(block)).message("Admonition block has unsupported type").actualValue(admonitionType).expectedValue("One of: " + String.join((CharSequence)", ", config.getAllowed())).build());
        }
    }

    private void validateTitle(String title, AdmonitionBlock.TitleConfig config, AdmonitionBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (title == null || title.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.title.required").location(context.createLocation(block)).message("Admonition block must have a title").actualValue("No title").expectedValue("Title required").build());
            return;
        }
        if (title != null) {
            if (config.getPattern() != null && !config.getPattern().matcher(title).matches()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.title.pattern").location(context.createLocation(block)).message("Admonition title does not match required pattern").actualValue(title).expectedValue("Pattern: " + config.getPattern().pattern()).build());
            }
            if (config.getMinLength() != null && title.length() < config.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.title.minLength").location(context.createLocation(block)).message("Admonition title is too short").actualValue(title.length() + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
            }
            if (config.getMaxLength() != null && title.length() > config.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.title.maxLength").location(context.createLocation(block)).message("Admonition title is too long").actualValue(title.length() + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
            }
        }
    }

    private void validateContent(String content, AdmonitionBlock.ContentConfig config, AdmonitionBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (content == null || content.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.content.required").location(context.createLocation(block)).message("Admonition block must have content").actualValue("No content").expectedValue("Content required").build());
            return;
        }
        int contentLength = content.trim().length();
        if (config.getMinLength() != null && contentLength < config.getMinLength()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.content.minLength").location(context.createLocation(block)).message("Admonition content is too short").actualValue(contentLength + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
        }
        if (config.getMaxLength() != null && contentLength > config.getMaxLength()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.content.maxLength").location(context.createLocation(block)).message("Admonition content is too long").actualValue(contentLength + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
        }
        if (config.getLines() != null) {
            this.validateLines(content, config.getLines(), config, blockConfig, context, block, messages);
        }
    }

    private void validateLines(String content, LineConfig config, AdmonitionBlock.ContentConfig contentConfig, AdmonitionBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = config.severity() != null ? config.severity() : (contentConfig.getSeverity() != null ? contentConfig.getSeverity() : blockConfig.getSeverity());
        int lineCount = this.countLines(content);
        if (config.min() != null && lineCount < config.min()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.content.lines.min").location(context.createLocation(block)).message("Admonition block has too few lines").actualValue(String.valueOf(lineCount)).expectedValue("At least " + config.min() + " lines").build());
        }
        if (config.max() != null && lineCount > config.max()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.content.lines.max").location(context.createLocation(block)).message("Admonition block has too many lines").actualValue(String.valueOf(lineCount)).expectedValue("At most " + config.max() + " lines").build());
        }
    }

    private void validateIcon(boolean hasIcon, AdmonitionBlock.IconConfig config, AdmonitionBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        String iconValue;
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && !hasIcon) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.icon.required").location(context.createLocation(block)).message("Admonition block must have an icon").actualValue("No icon").expectedValue("Icon required").build());
        }
        if (hasIcon && config.getPattern() != null && (iconValue = this.getIconValue(block)) != null && !config.getPattern().matcher(iconValue).matches()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("admonition.icon.pattern").location(context.createLocation(block)).message("Admonition icon does not match required pattern").actualValue(iconValue).expectedValue("Pattern: " + config.getPattern().pattern()).build());
        }
    }

    private String getIconValue(StructuralNode block) {
        Object icon = block.getAttribute((Object)"icon");
        return icon != null ? icon.toString() : null;
    }
}

