/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.AudioBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class AudioBlockValidator
extends AbstractBlockValidator<AudioBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.AUDIO;
    }

    @Override
    protected Class<AudioBlock> getBlockConfigClass() {
        return AudioBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, AudioBlock audioConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String audioUrl = this.getAudioUrl(block);
        String title = this.getTitle(block);
        if (audioConfig.getUrl() != null) {
            this.validateUrl(audioUrl, audioConfig.getUrl(), context, block, messages, audioConfig);
        }
        if (audioConfig.getOptions() != null) {
            this.validateOptions(block, audioConfig.getOptions(), context, messages, audioConfig);
        }
        if (audioConfig.getTitle() != null) {
            this.validateTitle(title, audioConfig.getTitle(), context, block, messages, audioConfig);
        }
        return messages;
    }

    private String getAudioUrl(StructuralNode block) {
        Object target = block.getAttribute((Object)"target");
        if (target != null) {
            return target.toString();
        }
        if (block.getContent() != null) {
            return block.getContent().toString();
        }
        return null;
    }

    private String getTitle(StructuralNode block) {
        String title = block.getTitle();
        if (title != null && !title.trim().isEmpty()) {
            return title;
        }
        Object caption = block.getAttribute((Object)"caption");
        if (caption != null) {
            return caption.toString();
        }
        return null;
    }

    private void validateUrl(String url, AudioBlock.UrlConfig urlConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, AudioBlock audioConfig) {
        Severity severity;
        Severity severity2 = severity = urlConfig.getSeverity() != null ? urlConfig.getSeverity() : audioConfig.getSeverity();
        if (urlConfig.isRequired() && (url == null || url.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.url.required").location(context.createLocation(block)).message("Audio must have a URL").actualValue("No URL").expectedValue("URL required").build());
            return;
        }
        if (url != null && !url.trim().isEmpty() && urlConfig.getPattern() != null && !urlConfig.getPattern().matcher(url).matches()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.url.pattern").location(context.createLocation(block)).message("Audio URL does not match required pattern").actualValue(url).expectedValue("Pattern: " + urlConfig.getPattern().pattern()).build());
        }
    }

    private void validateOptions(StructuralNode block, AudioBlock.OptionsConfig optionsConfig, BlockValidationContext context, List<ValidationMessage> messages, AudioBlock audioConfig) {
        if (optionsConfig.getAutoplay() != null) {
            this.validateAutoplay(block, optionsConfig.getAutoplay(), context, messages, audioConfig);
        }
        if (optionsConfig.getControls() != null) {
            this.validateControls(block, optionsConfig.getControls(), context, messages, audioConfig);
        }
        if (optionsConfig.getLoop() != null) {
            this.validateLoop(block, optionsConfig.getLoop(), context, messages, audioConfig);
        }
    }

    private void validateAutoplay(StructuralNode block, AudioBlock.AutoplayConfig autoplayConfig, BlockValidationContext context, List<ValidationMessage> messages, AudioBlock audioConfig) {
        Severity severity = autoplayConfig.getSeverity() != null ? autoplayConfig.getSeverity() : audioConfig.getSeverity();
        boolean hasAutoplay = this.hasOption(block, "autoplay");
        if (!autoplayConfig.isAllowed() && hasAutoplay) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.options.autoplay.notAllowed").location(context.createLocation(block)).message("Audio autoplay is not allowed").actualValue("autoplay enabled").expectedValue("autoplay must not be used").build());
        }
    }

    private void validateControls(StructuralNode block, AudioBlock.ControlsConfig controlsConfig, BlockValidationContext context, List<ValidationMessage> messages, AudioBlock audioConfig) {
        boolean hasControls;
        Severity severity = controlsConfig.getSeverity() != null ? controlsConfig.getSeverity() : audioConfig.getSeverity();
        boolean bl = hasControls = !this.hasOption(block, "nocontrols");
        if (controlsConfig.isRequired() && !hasControls) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.options.controls.required").location(context.createLocation(block)).message("Audio must display controls").actualValue("controls hidden").expectedValue("controls must be visible").build());
        }
    }

    private void validateLoop(StructuralNode block, AudioBlock.LoopConfig loopConfig, BlockValidationContext context, List<ValidationMessage> messages, AudioBlock audioConfig) {
        Severity severity = loopConfig.getSeverity() != null ? loopConfig.getSeverity() : audioConfig.getSeverity();
        boolean hasLoop = this.hasOption(block, "loop");
        if (!loopConfig.isAllowed() && hasLoop) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.options.loop.notAllowed").location(context.createLocation(block)).message("Audio loop is not allowed").actualValue("loop enabled").expectedValue("loop must not be used").build());
        }
    }

    private boolean hasOption(StructuralNode block, String option) {
        Object opts = block.getAttribute((Object)"opts");
        if (opts != null) {
            String optsStr = opts.toString();
            return optsStr.contains(option);
        }
        Object attr = block.getAttribute((Object)option);
        return attr != null && !"false".equals(attr.toString());
    }

    private void validateTitle(String title, AudioBlock.TitleConfig titleConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, AudioBlock audioConfig) {
        Severity severity;
        Severity severity2 = severity = titleConfig.getSeverity() != null ? titleConfig.getSeverity() : audioConfig.getSeverity();
        if (titleConfig.isRequired() && (title == null || title.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.title.required").location(context.createLocation(block)).message("Audio must have a title").actualValue("No title").expectedValue("Title required").build());
            return;
        }
        if (title != null && !title.trim().isEmpty()) {
            if (titleConfig.getMinLength() != null && title.length() < titleConfig.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.title.minLength").location(context.createLocation(block)).message("Audio title is too short").actualValue(title.length() + " characters").expectedValue("At least " + titleConfig.getMinLength() + " characters").build());
            }
            if (titleConfig.getMaxLength() != null && title.length() > titleConfig.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("audio.title.maxLength").location(context.createLocation(block)).message("Audio title is too long").actualValue(title.length() + " characters").expectedValue("At most " + titleConfig.getMaxLength() + " characters").build());
            }
        }
    }
}

