/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;

public final class BlockContainer {
    private final StructuralNode node;
    private final String containerType;

    private BlockContainer(StructuralNode node, String containerType) {
        this.node = Objects.requireNonNull(node, "Node must not be null");
        this.containerType = Objects.requireNonNull(containerType, "Container type must not be null");
    }

    public static BlockContainer fromDocument(Document document) {
        return new BlockContainer((StructuralNode)document, "document");
    }

    public static BlockContainer fromSection(Section section) {
        return new BlockContainer((StructuralNode)section, "section");
    }

    public List<StructuralNode> getBlocks() {
        if (this.node instanceof Document) {
            return this.getDocumentBlocks((Document)this.node);
        }
        if (this.node instanceof Section) {
            ArrayList<StructuralNode> blocks = new ArrayList<StructuralNode>();
            List nodeBlocks = this.node.getBlocks();
            if (nodeBlocks != null) {
                for (StructuralNode child : nodeBlocks) {
                    if (child instanceof Section) continue;
                    blocks.add(child);
                }
            }
            return blocks;
        }
        List nodeBlocks = this.node.getBlocks();
        return nodeBlocks != null ? nodeBlocks : new ArrayList();
    }

    private List<StructuralNode> getDocumentBlocks(Document document) {
        StructuralNode child2;
        ArrayList<StructuralNode> blocks = new ArrayList<StructuralNode>();
        List docBlocks = document.getBlocks();
        if (docBlocks == null) {
            return blocks;
        }
        for (StructuralNode child2 : docBlocks) {
            if (child2 == null || child2.getContext() == null || !child2.getContext().equals("preamble")) continue;
            List preambleBlocks = child2.getBlocks();
            if (preambleBlocks != null) {
                blocks.addAll(preambleBlocks);
            }
            return blocks;
        }
        Iterator iterator = docBlocks.iterator();
        while (iterator.hasNext() && !((child2 = (StructuralNode)iterator.next()) instanceof Section)) {
            if (child2 == null) continue;
            blocks.add(child2);
        }
        return blocks;
    }

    public StructuralNode getNode() {
        return this.node;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public boolean isDocument() {
        return this.node instanceof Document;
    }

    public boolean isSection() {
        return this.node instanceof Section;
    }
}

