/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.OccurrenceConfig;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class BlockOccurrenceValidator {
    public List<ValidationMessage> validate(BlockValidationContext context, List<Block> blocks) {
        Objects.requireNonNull(context, "[" + this.getClass().getName() + "] context must not be null");
        Objects.requireNonNull(blocks, "[" + this.getClass().getName() + "] blocks must not be null");
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (Block block : blocks) {
            if (block.getOccurrence() == null) continue;
            this.validateOccurrences(block, context, messages);
        }
        return messages;
    }

    private void validateOccurrences(Block block, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity;
        OccurrenceConfig occurrences = block.getOccurrence();
        int actualCount = context.getOccurrenceCount(block);
        String blockName = context.getBlockName(block);
        Severity severity2 = severity = occurrences.severity() != null ? occurrences.severity() : block.getSeverity();
        if (actualCount < occurrences.min()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("block.occurrences.min").location(this.createSectionLocation(context)).message("Too few occurrences of " + blockName).actualValue(String.valueOf(actualCount)).expectedValue("At least " + occurrences.min() + " occurrences").build());
        }
        if (actualCount > occurrences.max()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("block.occurrences.max").location(this.createSectionLocation(context)).message("Too many occurrences of " + blockName).actualValue(String.valueOf(actualCount)).expectedValue("At most " + occurrences.max() + " occurrences").build());
        }
    }

    private SourceLocation createSectionLocation(BlockValidationContext context) {
        return SourceLocation.builder().filename(context.getFilename()).startLine(1).build();
    }
}

