/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.config.rule.OrderConfig;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;

public final class BlockOrderValidator {
    public List<ValidationMessage> validate(BlockValidationContext context, OrderConfig orderConfig) {
        if (context == null || orderConfig == null) {
            return List.of();
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        List<BlockValidationContext.BlockPosition> actualOrder = context.getBlockOrder();
        if (orderConfig.fixedOrder() != null && !orderConfig.fixedOrder().isEmpty()) {
            this.validateFixedOrder(actualOrder, orderConfig, context, messages);
        }
        if (orderConfig.before() != null && !orderConfig.before().isEmpty()) {
            this.validateBeforeConstraints(actualOrder, orderConfig, context, messages);
        }
        if (orderConfig.after() != null && !orderConfig.after().isEmpty()) {
            this.validateAfterConstraints(actualOrder, orderConfig, context, messages);
        }
        return messages;
    }

    private void validateFixedOrder(List<BlockValidationContext.BlockPosition> actualOrder, OrderConfig orderConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        List<String> expectedOrder = orderConfig.fixedOrder();
        int expectedIndex = 0;
        for (BlockValidationContext.BlockPosition position : actualOrder) {
            String blockIdentifier = this.getBlockIdentifier(position.getConfig());
            int foundIndex = expectedOrder.indexOf(blockIdentifier);
            if (foundIndex < 0) continue;
            if (foundIndex < expectedIndex) {
                messages.add(ValidationMessage.builder().severity(orderConfig.severity()).ruleId("block.order.fixed").location(context.createLocation(position.getBlock())).message("Block '" + blockIdentifier + "' appears out of order").actualValue("Position " + (position.getIndex() + 1)).expectedValue("Should appear after '" + expectedOrder.get(expectedIndex - 1) + "'").build());
                continue;
            }
            expectedIndex = foundIndex + 1;
        }
    }

    private void validateBeforeConstraints(List<BlockValidationContext.BlockPosition> actualOrder, OrderConfig orderConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        for (OrderConfig.OrderConstraint constraint : orderConfig.before()) {
            this.validateBeforeConstraint(actualOrder, constraint, context, messages);
        }
    }

    private void validateBeforeConstraint(List<BlockValidationContext.BlockPosition> actualOrder, OrderConfig.OrderConstraint constraint, BlockValidationContext context, List<ValidationMessage> messages) {
        Integer firstPos = null;
        Integer secondPos = null;
        for (BlockValidationContext.BlockPosition position : actualOrder) {
            String identifier = this.getBlockIdentifier(position.getConfig());
            if (identifier.equals(constraint.first())) {
                firstPos = position.getIndex();
            }
            if (!identifier.equals(constraint.second())) continue;
            secondPos = position.getIndex();
        }
        if (firstPos != null && secondPos != null && firstPos > secondPos) {
            messages.add(ValidationMessage.builder().severity(constraint.severity()).ruleId("block.order.before").location(this.createSectionLocation(context)).message("Block '" + constraint.first() + "' must appear before '" + constraint.second() + "'").actualValue("'" + constraint.first() + "' at position " + (firstPos + 1) + ", '" + constraint.second() + "' at position " + (secondPos + 1)).expectedValue("'" + constraint.first() + "' before '" + constraint.second() + "'").build());
        }
    }

    private void validateAfterConstraints(List<BlockValidationContext.BlockPosition> actualOrder, OrderConfig orderConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        for (OrderConfig.OrderConstraint constraint : orderConfig.after()) {
            this.validateAfterConstraint(actualOrder, constraint, context, messages);
        }
    }

    private void validateAfterConstraint(List<BlockValidationContext.BlockPosition> actualOrder, OrderConfig.OrderConstraint constraint, BlockValidationContext context, List<ValidationMessage> messages) {
        Integer firstPos = null;
        Integer secondPos = null;
        for (BlockValidationContext.BlockPosition position : actualOrder) {
            String identifier = this.getBlockIdentifier(position.getConfig());
            if (identifier.equals(constraint.first())) {
                firstPos = position.getIndex();
            }
            if (!identifier.equals(constraint.second())) continue;
            secondPos = position.getIndex();
        }
        if (firstPos != null && secondPos != null && firstPos < secondPos) {
            messages.add(ValidationMessage.builder().severity(constraint.severity()).ruleId("block.order.after").location(this.createSectionLocation(context)).message("Block '" + constraint.first() + "' must appear after '" + constraint.second() + "'").actualValue("'" + constraint.first() + "' at position " + (firstPos + 1) + ", '" + constraint.second() + "' at position " + (secondPos + 1)).expectedValue("'" + constraint.first() + "' after '" + constraint.second() + "'").build());
        }
    }

    private String getBlockIdentifier(Block block) {
        if (block.getName() != null) {
            return block.getName();
        }
        return block.getType().toString().toLowerCase();
    }

    private SourceLocation createSectionLocation(BlockValidationContext context) {
        return SourceLocation.builder().filename(context.getFilename()).startLine(1).build();
    }
}

