/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import org.asciidoctor.ast.StructuralNode;

public final class BlockTypeDetector {
    public BlockType detectType(StructuralNode node) {
        if (node == null) {
            return null;
        }
        try {
            String context = node.getContext();
            if (context == null) {
                return null;
            }
            switch (context) {
                case "paragraph": {
                    return BlockType.PARAGRAPH;
                }
                case "listing": {
                    return BlockType.LISTING;
                }
                case "literal": {
                    return BlockType.LITERAL;
                }
                case "table": {
                    return BlockType.TABLE;
                }
                case "image": {
                    return BlockType.IMAGE;
                }
                case "verse": 
                case "quote": {
                    return this.detectVerseOrQuote(node);
                }
                case "admonition": {
                    return BlockType.ADMONITION;
                }
                case "pass": {
                    return BlockType.PASS;
                }
                case "sidebar": {
                    return BlockType.SIDEBAR;
                }
                case "audio": {
                    return BlockType.AUDIO;
                }
                case "example": 
                case "open": {
                    return this.detectFromContent(node);
                }
                case "preamble": {
                    return null;
                }
                case "ulist": {
                    return BlockType.ULIST;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private BlockType detectVerseOrQuote(StructuralNode node) {
        if ("verse".equals(node.getStyle())) {
            return BlockType.VERSE;
        }
        if ("verse".equals(node.getContext())) {
            return BlockType.VERSE;
        }
        if ("quote".equals(node.getContext())) {
            return BlockType.QUOTE;
        }
        if (node.getAttribute((Object)"attribution") != null || node.getAttribute((Object)"citetitle") != null || node.getAttribute((Object)"author") != null || node.getAttribute((Object)"source") != null) {
            return BlockType.QUOTE;
        }
        return null;
    }

    private BlockType detectFromContent(StructuralNode node) {
        String style = node.getStyle();
        if (style != null) {
            switch (style) {
                case "source": 
                case "listing": {
                    return BlockType.LISTING;
                }
                case "verse": {
                    return BlockType.VERSE;
                }
            }
        }
        if (node.hasRole("image") || "image".equals(node.getNodeName())) {
            return BlockType.IMAGE;
        }
        return null;
    }

    public boolean isBlockType(StructuralNode node, BlockType type) {
        return type == this.detectType(node);
    }
}

