/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.blocks.Block;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.Section;
import org.asciidoctor.ast.StructuralNode;

public final class BlockValidationContext {
    private final StructuralNode container;
    private final String filename;
    private final Map<String, List<BlockOccurrence>> occurrences;
    private final List<BlockPosition> blockOrder;

    public BlockValidationContext(Section section, String filename) {
        this.container = (StructuralNode)Objects.requireNonNull(section, "[" + this.getClass().getName() + "] section must not be null");
        this.filename = Objects.requireNonNull(filename, "[" + this.getClass().getName() + "] filename must not be null");
        this.occurrences = new HashMap<String, List<BlockOccurrence>>();
        this.blockOrder = new ArrayList<BlockPosition>();
    }

    public BlockValidationContext(Document document, String filename) {
        this.container = (StructuralNode)Objects.requireNonNull(document, "[" + this.getClass().getName() + "] document must not be null");
        this.filename = Objects.requireNonNull(filename, "[" + this.getClass().getName() + "] filename must not be null");
        this.occurrences = new HashMap<String, List<BlockOccurrence>>();
        this.blockOrder = new ArrayList<BlockPosition>();
    }

    public Section getSection() {
        return this.container instanceof Section ? (Section)this.container : null;
    }

    public StructuralNode getContainer() {
        return this.container;
    }

    public String getFilename() {
        return this.filename;
    }

    public SourceLocation createLocation(StructuralNode block) {
        int line = 1;
        if (block.getSourceLocation() != null) {
            line = block.getSourceLocation().getLineNumber();
        }
        return SourceLocation.builder().filename(this.filename).startLine(line).build();
    }

    public void trackBlock(Block config, StructuralNode block) {
        String key = this.createOccurrenceKey(config);
        BlockOccurrence occurrence = new BlockOccurrence(config, block, this.blockOrder.size());
        this.occurrences.computeIfAbsent(key, k -> new ArrayList()).add(occurrence);
        this.blockOrder.add(new BlockPosition(config, block, this.blockOrder.size()));
    }

    public List<BlockOccurrence> getOccurrences(Block config) {
        String key = this.createOccurrenceKey(config);
        return this.occurrences.getOrDefault(key, Collections.emptyList());
    }

    public int getOccurrenceCount(Block config) {
        return this.getOccurrences(config).size();
    }

    public List<BlockPosition> getBlockOrder() {
        return new ArrayList<BlockPosition>(this.blockOrder);
    }

    public String getBlockName(Block config) {
        if (config.getName() != null) {
            return "block '" + config.getName() + "'";
        }
        return config.getType().toString().toLowerCase() + " block";
    }

    private String createOccurrenceKey(Block config) {
        if (config.getName() != null) {
            return String.valueOf((Object)config.getType()) + ":" + config.getName();
        }
        return config.getType().toString();
    }

    public static final class BlockOccurrence {
        private final Block config;
        private final StructuralNode block;
        private final int position;

        BlockOccurrence(Block config, StructuralNode block, int position) {
            this.config = config;
            this.block = block;
            this.position = position;
        }

        public Block getConfig() {
            return this.config;
        }

        public StructuralNode getBlock() {
            return this.block;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static final class BlockPosition {
        private final Block config;
        private final StructuralNode block;
        private final int index;

        BlockPosition(Block config, StructuralNode block, int index) {
            this.config = config;
            this.block = block;
            this.index = index;
        }

        public Block getConfig() {
            return this.config;
        }

        public StructuralNode getBlock() {
            return this.block;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

