/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.validator.block.AdmonitionBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.AudioBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockTypeValidator;
import com.dataliquid.asciidoc.linter.validator.block.ExampleBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.ImageBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.ListingBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.LiteralBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.ParagraphBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.PassBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.QuoteBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.SidebarBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.TableBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.UlistBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.VerseBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.VideoBlockValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class BlockValidatorFactory {
    private final Map<BlockType, BlockTypeValidator> validators = this.createValidators();

    public BlockTypeValidator getValidator(BlockType type) {
        return this.validators.get((Object)type);
    }

    public boolean hasValidator(BlockType type) {
        return this.validators.containsKey((Object)type);
    }

    private Map<BlockType, BlockTypeValidator> createValidators() {
        HashMap<BlockType, BlockTypeValidator> map = new HashMap<BlockType, BlockTypeValidator>();
        this.registerValidator(map, new ParagraphBlockValidator());
        this.registerValidator(map, new TableBlockValidator());
        this.registerValidator(map, new ImageBlockValidator());
        this.registerValidator(map, new ListingBlockValidator());
        this.registerValidator(map, new VerseBlockValidator());
        this.registerValidator(map, new AdmonitionBlockValidator());
        this.registerValidator(map, new PassBlockValidator());
        this.registerValidator(map, new LiteralBlockValidator());
        this.registerValidator(map, new AudioBlockValidator());
        this.registerValidator(map, new QuoteBlockValidator());
        this.registerValidator(map, new SidebarBlockValidator());
        this.registerValidator(map, new ExampleBlockValidator());
        this.registerValidator(map, new VideoBlockValidator());
        this.registerValidator(map, new UlistBlockValidator());
        return map;
    }

    private void registerValidator(Map<BlockType, BlockTypeValidator> map, BlockTypeValidator validator) {
        Objects.requireNonNull(validator, "[" + this.getClass().getName() + "] validator must not be null");
        BlockType type = validator.getSupportedType();
        if (type == null) {
            throw new IllegalStateException("Validator " + validator.getClass().getName() + " returned null from getSupportedType()");
        }
        if (map.containsKey((Object)type)) {
            throw new IllegalStateException("Duplicate validator for type " + String.valueOf((Object)type) + ": " + map.get((Object)type).getClass().getName() + " and " + validator.getClass().getName());
        }
        map.put(type, validator);
    }
}

