/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.ExampleBlock;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class ExampleBlockValidator
extends AbstractBlockValidator<ExampleBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.EXAMPLE;
    }

    @Override
    protected Class<ExampleBlock> getBlockConfigClass() {
        return ExampleBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode node, ExampleBlock exampleBlock, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (exampleBlock.getCaption() != null) {
            messages.addAll(this.validateCaption(node, exampleBlock, context));
        }
        if (exampleBlock.getCollapsible() != null) {
            messages.addAll(this.validateCollapsible(node, exampleBlock, context));
        }
        return messages;
    }

    private List<ValidationMessage> validateCaption(StructuralNode node, ExampleBlock block, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ExampleBlock.CaptionConfig config = block.getCaption();
        String caption = node.getTitle();
        if (config.isRequired() && (caption == null || caption.trim().isEmpty())) {
            messages.add(this.createMessage("Example block requires a caption", this.determineSeverity(config.getSeverity(), block.getSeverity()), context.createLocation(node)));
            return messages;
        }
        if (caption == null || caption.trim().isEmpty()) {
            return messages;
        }
        if (config.getMinLength() != null && caption.length() < config.getMinLength()) {
            messages.add(this.createMessage(String.format("Example caption length %d is less than required minimum %d", caption.length(), config.getMinLength()), this.determineSeverity(config.getSeverity(), block.getSeverity()), context.createLocation(node)));
        }
        if (config.getMaxLength() != null && caption.length() > config.getMaxLength()) {
            messages.add(this.createMessage(String.format("Example caption length %d exceeds maximum %d", caption.length(), config.getMaxLength()), this.determineSeverity(config.getSeverity(), block.getSeverity()), context.createLocation(node)));
        }
        if (config.getPattern() != null && !config.getPattern().matcher(caption).matches()) {
            messages.add(this.createMessage(String.format("Example caption '%s' does not match required pattern '%s'", caption, config.getPattern().pattern()), this.determineSeverity(config.getSeverity(), block.getSeverity()), context.createLocation(node)));
        }
        return messages;
    }

    private List<ValidationMessage> validateCollapsible(StructuralNode node, ExampleBlock block, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        ExampleBlock.CollapsibleConfig config = block.getCollapsible();
        Object collapsibleAttr = node.getAttribute((Object)"collapsible-option");
        if (collapsibleAttr == null) {
            collapsibleAttr = node.getAttribute((Object)"collapsible");
        }
        if (config.isRequired() && collapsibleAttr == null) {
            messages.add(this.createMessage("Example block requires a collapsible attribute", this.determineSeverity(config.getSeverity(), block.getSeverity()), context.createLocation(node)));
            return messages;
        }
        if (collapsibleAttr == null) {
            return messages;
        }
        Boolean collapsibleValue = null;
        if (collapsibleAttr instanceof Boolean) {
            collapsibleValue = (Boolean)collapsibleAttr;
        } else if (collapsibleAttr instanceof String) {
            String strValue = ((String)collapsibleAttr).toLowerCase();
            if ("true".equals(strValue) || "yes".equals(strValue) || "1".equals(strValue)) {
                collapsibleValue = true;
            } else if ("false".equals(strValue) || "no".equals(strValue) || "0".equals(strValue)) {
                collapsibleValue = false;
            }
        }
        if (!(config.getAllowed() == null || config.getAllowed().isEmpty() || collapsibleValue != null && config.getAllowed().contains(collapsibleValue))) {
            messages.add(this.createMessage(String.format("Example collapsible value '%s' is not in allowed values %s", collapsibleAttr, config.getAllowed()), this.determineSeverity(config.getSeverity(), block.getSeverity()), context.createLocation(node)));
        }
        return messages;
    }

    private ValidationMessage createMessage(String message, Severity severity, SourceLocation location) {
        return ValidationMessage.builder().message(message).severity(severity).location(location).ruleId("example-block").build();
    }

    private Severity determineSeverity(Severity specificSeverity, Severity blockSeverity) {
        return specificSeverity != null ? specificSeverity : blockSeverity;
    }
}

