/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.blocks.ImageBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class ImageBlockValidator
extends AbstractBlockValidator<ImageBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.IMAGE;
    }

    @Override
    protected Class<ImageBlock> getBlockConfigClass() {
        return ImageBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, ImageBlock imageConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String imageUrl = this.getImageUrl(block);
        String altText = this.getAltText(block);
        if (imageConfig.getUrl() != null) {
            this.validateUrl(imageUrl, imageConfig.getUrl(), context, block, messages, imageConfig);
        }
        if (imageConfig.getWidth() != null) {
            this.validateDimension(block, "width", imageConfig.getWidth(), context, messages, imageConfig);
        }
        if (imageConfig.getHeight() != null) {
            this.validateDimension(block, "height", imageConfig.getHeight(), context, messages, imageConfig);
        }
        if (imageConfig.getAlt() != null) {
            this.validateAltText(altText, imageConfig.getAlt(), context, block, messages, imageConfig);
        }
        return messages;
    }

    private String getImageUrl(StructuralNode block) {
        Object target = block.getAttribute((Object)"target");
        if (target != null) {
            return target.toString();
        }
        if (block.getContent() != null) {
            return block.getContent().toString();
        }
        return null;
    }

    private String getAltText(StructuralNode block) {
        Object alt = block.getAttribute((Object)"alt");
        return alt != null ? alt.toString() : null;
    }

    private void validateUrl(String url, ImageBlock.UrlConfig urlConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, ImageBlock imageConfig) {
        if (urlConfig.isRequired() && (url == null || url.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image.url.required").location(context.createLocation(block)).message("Image must have a URL").actualValue("No URL").expectedValue("URL required").build());
            return;
        }
        if (url != null && !url.trim().isEmpty() && urlConfig.getPattern() != null && !urlConfig.getPattern().matcher(url).matches()) {
            messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image.url.pattern").location(context.createLocation(block)).message("Image URL does not match required pattern").actualValue(url).expectedValue("Pattern: " + urlConfig.getPattern().pattern()).build());
        }
    }

    private void validateDimension(StructuralNode block, String dimensionName, ImageBlock.DimensionConfig dimConfig, BlockValidationContext context, List<ValidationMessage> messages, ImageBlock imageConfig) {
        Integer numericValue;
        String valueStr;
        Object value = block.getAttribute((Object)dimensionName);
        String string = valueStr = value != null ? value.toString() : null;
        if (dimConfig.isRequired() && (valueStr == null || valueStr.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image." + dimensionName + ".required").location(context.createLocation(block)).message("Image must have " + dimensionName + " specified").actualValue("No " + dimensionName).expectedValue(dimensionName + " required").build());
            return;
        }
        if (valueStr != null && (numericValue = this.parseNumericValue(valueStr)) != null) {
            if (dimConfig.getMinValue() != null && numericValue < dimConfig.getMinValue()) {
                messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image." + dimensionName + ".min").location(context.createLocation(block)).message("Image " + dimensionName + " is too small").actualValue(numericValue + "px").expectedValue("At least " + dimConfig.getMinValue() + "px").build());
            }
            if (dimConfig.getMaxValue() != null && numericValue > dimConfig.getMaxValue()) {
                messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image." + dimensionName + ".max").location(context.createLocation(block)).message("Image " + dimensionName + " is too large").actualValue(numericValue + "px").expectedValue("At most " + dimConfig.getMaxValue() + "px").build());
            }
        }
    }

    private Integer parseNumericValue(String value) {
        if (value == null) {
            return null;
        }
        String numeric = value.replaceAll("[^0-9]", "");
        if (!numeric.isEmpty()) {
            try {
                return Integer.parseInt(numeric);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private void validateAltText(String altText, ImageBlock.AltTextConfig altConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, ImageBlock imageConfig) {
        if (altConfig.isRequired() && (altText == null || altText.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image.alt.required").location(context.createLocation(block)).message("Image must have alt text").actualValue("No alt text").expectedValue("Alt text required").build());
            return;
        }
        if (altText != null && !altText.trim().isEmpty()) {
            if (altConfig.getMinLength() != null && altText.length() < altConfig.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image.alt.minLength").location(context.createLocation(block)).message("Image alt text is too short").actualValue(altText.length() + " characters").expectedValue("At least " + altConfig.getMinLength() + " characters").build());
            }
            if (altConfig.getMaxLength() != null && altText.length() > altConfig.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(imageConfig.getSeverity()).ruleId("image.alt.maxLength").location(context.createLocation(block)).message("Image alt text is too long").actualValue(altText.length() + " characters").expectedValue("At most " + altConfig.getMaxLength() + " characters").build());
            }
        }
    }
}

