/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.ListingBlock;
import com.dataliquid.asciidoc.linter.config.rule.LineConfig;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class ListingBlockValidator
extends AbstractBlockValidator<ListingBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.LISTING;
    }

    @Override
    protected Class<ListingBlock> getBlockConfigClass() {
        return ListingBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, ListingBlock listingConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String language = this.getLanguage(block);
        String title = block.getTitle();
        String content = this.getBlockContent(block);
        if (listingConfig.getLanguage() != null) {
            this.validateLanguage(language, listingConfig.getLanguage(), listingConfig, context, block, messages);
        }
        if (listingConfig.getTitle() != null) {
            this.validateTitle(title, listingConfig.getTitle(), listingConfig, context, block, messages);
        }
        if (listingConfig.getLines() != null) {
            this.validateLines(content, listingConfig.getLines(), listingConfig, context, block, messages);
        }
        if (listingConfig.getCallouts() != null) {
            this.validateCallouts(content, listingConfig.getCallouts(), listingConfig, context, block, messages);
        }
        return messages;
    }

    private String getLanguage(StructuralNode block) {
        Object lang = block.getAttribute((Object)"language");
        if (lang != null) {
            return lang.toString();
        }
        lang = block.getAttribute((Object)"source");
        if (lang != null) {
            return lang.toString();
        }
        String style = block.getStyle();
        if (style != null && !"source".equals(style)) {
            return style;
        }
        return null;
    }

    private void validateLanguage(String language, ListingBlock.LanguageConfig config, ListingBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (language == null || language.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.language.required").location(context.createLocation(block)).message("Listing block must specify a language").actualValue("No language").expectedValue("Language required").build());
        }
        if (language != null && config.getAllowed() != null && !config.getAllowed().isEmpty() && !config.getAllowed().contains(language)) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.language.allowed").location(context.createLocation(block)).message("Listing block has unsupported language").actualValue(language).expectedValue("One of: " + String.join((CharSequence)", ", config.getAllowed())).build());
        }
    }

    private void validateTitle(String title, ListingBlock.TitleConfig config, ListingBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (title == null || title.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.title.required").location(context.createLocation(block)).message("Listing block must have a title").actualValue("No title").expectedValue("Title required").build());
            return;
        }
        if (title != null && config.getPattern() != null && !config.getPattern().matcher(title).matches()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.title.pattern").location(context.createLocation(block)).message("Code listing title does not match required pattern").actualValue(title).expectedValue("Pattern: " + config.getPattern().pattern()).build());
        }
    }

    private void validateLines(String content, LineConfig config, ListingBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = config.severity() != null ? config.severity() : blockConfig.getSeverity();
        int lineCount = this.countLines(content);
        if (config.min() != null && lineCount < config.min()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.lines.min").location(context.createLocation(block)).message("Listing block has too few lines").actualValue(String.valueOf(lineCount)).expectedValue("At least " + config.min() + " lines").build());
        }
        if (config.max() != null && lineCount > config.max()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.lines.max").location(context.createLocation(block)).message("Listing block has too many lines").actualValue(String.valueOf(lineCount)).expectedValue("At most " + config.max() + " lines").build());
        }
    }

    private void validateCallouts(String content, ListingBlock.CalloutsConfig config, ListingBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        int calloutCount = this.countCallouts(content);
        if (!config.isAllowed() && calloutCount > 0) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.callouts.notAllowed").location(context.createLocation(block)).message("Listing block must not contain callouts").actualValue(calloutCount + " callouts").expectedValue("No callouts allowed").build());
        }
        if (config.getMax() != null && calloutCount > config.getMax()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("listing.callouts.max").location(context.createLocation(block)).message("Listing block has too many callouts").actualValue(String.valueOf(calloutCount)).expectedValue("At most " + config.getMax() + " callouts").build());
        }
    }

    private int countCallouts(String content) {
        String[] lines;
        if (content == null || content.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (String line : lines = content.split("\n")) {
            if (!line.matches(".*<\\d+>.*")) continue;
            ++count;
        }
        return count;
    }
}

