/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.LiteralBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class LiteralBlockValidator
extends AbstractBlockValidator<LiteralBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.LITERAL;
    }

    @Override
    protected Class<LiteralBlock> getBlockConfigClass() {
        return LiteralBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, LiteralBlock config, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String title = this.getTitle(block);
        List<String> lines = this.getContentLines(block);
        if (config.getTitle() != null) {
            this.validateTitle(title, config.getTitle(), config, context, block, messages);
        }
        if (config.getLines() != null) {
            this.validateLines(lines, config.getLines(), config, context, block, messages);
        }
        if (config.getIndentation() != null) {
            this.validateIndentation(lines, config.getIndentation(), config, context, block, messages);
        }
        return messages;
    }

    private String getTitle(StructuralNode block) {
        String titleObj = block.getTitle();
        return titleObj != null ? titleObj.toString() : null;
    }

    private List<String> getContentLines(StructuralNode block) {
        ArrayList<String> lines = new ArrayList<String>();
        String content = this.getBlockContent(block);
        if (!content.isEmpty()) {
            String[] contentLines;
            for (String line : contentLines = content.split("\n")) {
                lines.add(line);
            }
        }
        return lines;
    }

    private void validateTitle(String title, LiteralBlock.TitleConfig config, LiteralBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = this.resolveSeverity(config.getSeverity(), blockConfig.getSeverity());
        ValidationMessage requiredMessage = this.validateRequired(title, "title", config.isRequired(), severity, context, block);
        if (requiredMessage != null) {
            messages.add(requiredMessage);
            return;
        }
        if (title != null && !title.trim().isEmpty()) {
            String trimmedTitle = title.trim();
            ValidationMessage lengthMessage = this.validateLength(trimmedTitle, config.getMinLength(), config.getMaxLength(), "title", severity, context, block);
            this.addIfNotNull(messages, lengthMessage);
        }
    }

    private void validateLines(List<String> lines, LiteralBlock.LinesConfig config, LiteralBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = this.resolveSeverity(config.getSeverity(), blockConfig.getSeverity());
        int lineCount = lines.size();
        ValidationMessage countMessage = this.validateMinMax(lineCount, config.getMin(), config.getMax(), "Line count", severity, context, block);
        this.addIfNotNull(messages, countMessage);
    }

    private void validateIndentation(List<String> lines, LiteralBlock.IndentationConfig config, LiteralBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = this.resolveSeverity(config.getSeverity(), blockConfig.getSeverity());
        if (!config.isRequired()) {
            return;
        }
        Integer firstIndentation = null;
        int lineNumber = 0;
        for (String line : lines) {
            ++lineNumber;
            if (line.isEmpty() || line.trim().isEmpty()) continue;
            int indentSpaces = this.countLeadingSpaces(line);
            if (config.getMinSpaces() != null && indentSpaces < config.getMinSpaces()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("literal.indentation.minSpaces").location(context.createLocation(block)).message("Line " + lineNumber + " has insufficient indentation").actualValue(indentSpaces + " spaces").expectedValue("At least " + config.getMinSpaces() + " spaces").build());
            }
            if (config.getMaxSpaces() != null && indentSpaces > config.getMaxSpaces()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("literal.indentation.maxSpaces").location(context.createLocation(block)).message("Line " + lineNumber + " has excessive indentation").actualValue(indentSpaces + " spaces").expectedValue("At most " + config.getMaxSpaces() + " spaces").build());
            }
            if (!config.isConsistent()) continue;
            if (firstIndentation == null) {
                firstIndentation = indentSpaces;
                continue;
            }
            if (indentSpaces == firstIndentation) continue;
            messages.add(ValidationMessage.builder().severity(severity).ruleId("literal.indentation.consistent").location(context.createLocation(block)).message("Line " + lineNumber + " has inconsistent indentation").actualValue(indentSpaces + " spaces").expectedValue(firstIndentation + " spaces (consistent with first non-empty line)").build());
        }
    }

    private int countLeadingSpaces(String line) {
        int count = 0;
        for (char c : line.toCharArray()) {
            if (c == ' ') {
                ++count;
                continue;
            }
            if (c != '\t') break;
            count += 4;
        }
        return count;
    }
}

