/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.ParagraphBlock;
import com.dataliquid.asciidoc.linter.config.rule.LineConfig;
import com.dataliquid.asciidoc.linter.config.rule.OccurrenceConfig;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class ParagraphBlockValidator
extends AbstractBlockValidator<ParagraphBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.PARAGRAPH;
    }

    @Override
    protected Class<ParagraphBlock> getBlockConfigClass() {
        return ParagraphBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, ParagraphBlock paragraphConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String content = this.getBlockContent(block);
        if (paragraphConfig.getLines() != null) {
            int lineCount = this.countLinesNonEmpty(content);
            this.validateLineCount(lineCount, paragraphConfig.getLines(), paragraphConfig, context, block, messages);
        }
        if (paragraphConfig.getSentence() != null) {
            this.validateSentences(content, paragraphConfig.getSentence(), paragraphConfig, context, block, messages);
        }
        return messages;
    }

    private int countLinesNonEmpty(String content) {
        if (content == null || content.isEmpty()) {
            return 0;
        }
        String[] lines = content.split("\n");
        int count = 0;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            ++count;
        }
        return count;
    }

    private void validateLineCount(int actualLines, LineConfig lineConfig, ParagraphBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = lineConfig.severity() != null ? lineConfig.severity() : blockConfig.getSeverity();
        if (lineConfig.min() != null && actualLines < lineConfig.min()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.lines.min").location(context.createLocation(block)).message("Paragraph has too few lines").actualValue(String.valueOf(actualLines)).expectedValue("At least " + lineConfig.min() + " lines").build());
        }
        if (lineConfig.max() != null && actualLines > lineConfig.max()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.lines.max").location(context.createLocation(block)).message("Paragraph has too many lines").actualValue(String.valueOf(actualLines)).expectedValue("At most " + lineConfig.max() + " lines").build());
        }
    }

    private void validateSentences(String content, ParagraphBlock.SentenceConfig sentenceConfig, ParagraphBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        if (content == null || content.isEmpty()) {
            if (sentenceConfig.getOccurrence() != null && sentenceConfig.getOccurrence().min() > 0) {
                Severity severity = sentenceConfig.getOccurrence().severity() != null ? sentenceConfig.getOccurrence().severity() : blockConfig.getSeverity();
                messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.sentence.occurrence.min").location(context.createLocation(block)).message("Paragraph has too few sentences").actualValue("0").expectedValue("At least " + sentenceConfig.getOccurrence().min() + " sentences").build());
            }
            return;
        }
        List<String> sentences = this.splitIntoSentences(content);
        if (sentenceConfig.getOccurrence() != null) {
            this.validateSentenceOccurrence(sentences.size(), sentenceConfig.getOccurrence(), blockConfig, context, block, messages);
        }
        if (sentenceConfig.getWords() != null) {
            this.validateWordsPerSentence(sentences, sentenceConfig.getWords(), blockConfig, context, block, messages);
        }
    }

    private List<String> splitIntoSentences(String content) {
        String[] parts;
        ArrayList<String> sentences = new ArrayList<String>();
        String normalizedContent = content.replaceAll("\\n+", " ").trim();
        for (String part : parts = normalizedContent.split("(?<=[.!?])\\s+")) {
            String trimmed = part.trim();
            if (trimmed.isEmpty()) continue;
            sentences.add(trimmed);
        }
        if (sentences.isEmpty() && !normalizedContent.trim().isEmpty()) {
            sentences.add(normalizedContent.trim());
        }
        return sentences;
    }

    private void validateSentenceOccurrence(int sentenceCount, OccurrenceConfig occurrenceConfig, ParagraphBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = occurrenceConfig.severity() != null ? occurrenceConfig.severity() : blockConfig.getSeverity();
        if (sentenceCount < occurrenceConfig.min()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.sentence.occurrence.min").location(context.createLocation(block)).message("Paragraph has too few sentences").actualValue(String.valueOf(sentenceCount)).expectedValue("At least " + occurrenceConfig.min() + " sentences").build());
        }
        if (sentenceCount > occurrenceConfig.max()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.sentence.occurrence.max").location(context.createLocation(block)).message("Paragraph has too many sentences").actualValue(String.valueOf(sentenceCount)).expectedValue("At most " + occurrenceConfig.max() + " sentences").build());
        }
    }

    private void validateWordsPerSentence(List<String> sentences, ParagraphBlock.WordsConfig wordsConfig, ParagraphBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = wordsConfig.getSeverity() != null ? wordsConfig.getSeverity() : blockConfig.getSeverity();
        for (int i = 0; i < sentences.size(); ++i) {
            String sentence = sentences.get(i);
            int wordCount = this.countWords(sentence);
            if (wordsConfig.getMin() != null && wordCount < wordsConfig.getMin()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.sentence.words.min").location(context.createLocation(block)).message("Sentence " + (i + 1) + " has too few words").actualValue(wordCount + " words").expectedValue("At least " + wordsConfig.getMin() + " words").build());
            }
            if (wordsConfig.getMax() == null || wordCount <= wordsConfig.getMax()) continue;
            messages.add(ValidationMessage.builder().severity(severity).ruleId("paragraph.sentence.words.max").location(context.createLocation(block)).message("Sentence " + (i + 1) + " has too many words").actualValue(wordCount + " words").expectedValue("At most " + wordsConfig.getMax() + " words").build());
        }
    }

    private int countWords(String text) {
        if (text == null || text.trim().isEmpty()) {
            return 0;
        }
        String[] words = text.trim().split("\\s+");
        return words.length;
    }
}

