/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.PassBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class PassBlockValidator
extends AbstractBlockValidator<PassBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.PASS;
    }

    @Override
    protected Class<PassBlock> getBlockConfigClass() {
        return PassBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, PassBlock passConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String passType = this.getAttributeAsString(block, "pass-type");
        String passReason = this.getAttributeAsString(block, "pass-reason");
        String content = this.getBlockContent(block);
        if (passConfig.getTypeConfig() != null) {
            this.validateType(passType, passConfig.getTypeConfig(), passConfig, context, block, messages);
        }
        if (passConfig.getContent() != null) {
            this.validateContent(content, passConfig.getContent(), passConfig, context, block, messages);
        }
        if (passConfig.getReason() != null) {
            this.validateReason(passReason, passConfig.getReason(), passConfig, context, block, messages);
        }
        return messages;
    }

    private String getAttributeAsString(StructuralNode block, String attributeName) {
        Object value = block.getAttribute((Object)attributeName);
        return value != null ? value.toString() : null;
    }

    private void validateType(String passType, PassBlock.TypeConfig config, PassBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (passType == null || passType.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.type.required").location(context.createLocation(block)).message("Pass block must specify a type via pass-type attribute").actualValue("No type specified").expectedValue("Type required (pass-type attribute)").build());
        }
        if (passType != null && config.getAllowed() != null && !config.getAllowed().isEmpty() && !config.getAllowed().contains(passType)) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.type.allowed").location(context.createLocation(block)).message("Pass block has unsupported type").actualValue(passType).expectedValue("One of: " + String.join((CharSequence)", ", config.getAllowed())).build());
        }
    }

    private void validateContent(String content, PassBlock.ContentConfig config, PassBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        int contentLength;
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (content == null || content.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.content.required").location(context.createLocation(block)).message("Pass block must have content").actualValue("No content").expectedValue("Content required").build());
            return;
        }
        if (content != null && config.getMaxLength() != null && (contentLength = content.length()) > config.getMaxLength()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.content.maxLength").location(context.createLocation(block)).message("Pass block content exceeds maximum length").actualValue(contentLength + " characters").expectedValue("Maximum " + config.getMaxLength() + " characters").build());
        }
        if (content != null && config.getPattern() != null && !config.getPattern().matcher(content).matches()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.content.pattern").location(context.createLocation(block)).message("Pass block content does not match required pattern").actualValue("Content does not match pattern").expectedValue("Pattern: " + config.getPattern().pattern()).build());
        }
    }

    private void validateReason(String passReason, PassBlock.ReasonConfig config, PassBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.isRequired() && (passReason == null || passReason.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.reason.required").location(context.createLocation(block)).message("Pass block must provide reason via pass-reason attribute").actualValue("No reason provided").expectedValue("Reason required (pass-reason attribute)").build());
            return;
        }
        if (passReason != null) {
            int reasonLength = passReason.length();
            if (config.getMinLength() != null && reasonLength < config.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.reason.minLength").location(context.createLocation(block)).message("Pass block reason is too short").actualValue(reasonLength + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
            }
            if (config.getMaxLength() != null && reasonLength > config.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("pass.reason.maxLength").location(context.createLocation(block)).message("Pass block reason is too long").actualValue(reasonLength + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
            }
        }
    }
}

