/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.SidebarBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.asciidoctor.ast.StructuralNode;

public final class SidebarBlockValidator
extends AbstractBlockValidator<SidebarBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.SIDEBAR;
    }

    @Override
    protected Class<SidebarBlock> getBlockConfigClass() {
        return SidebarBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, SidebarBlock sidebarConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (sidebarConfig.getTitle() != null) {
            this.validateTitle(block, sidebarConfig, context, messages);
        }
        if (sidebarConfig.getContent() != null) {
            this.validateContent(block, sidebarConfig, context, messages);
        }
        if (sidebarConfig.getPosition() != null) {
            this.validatePosition(block, sidebarConfig, context, messages);
        }
        return messages;
    }

    private void validateTitle(StructuralNode block, SidebarBlock config, BlockValidationContext context, List<ValidationMessage> messages) {
        Pattern pattern;
        Severity severity;
        SidebarBlock.TitleConfig titleConfig = config.getTitle();
        String title = block.getTitle();
        boolean hasTitle = title != null && !title.trim().isEmpty();
        Severity severity2 = severity = titleConfig.getSeverity() != null ? titleConfig.getSeverity() : config.getSeverity();
        if (titleConfig.isRequired() && !hasTitle) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.title.required").location(context.createLocation(block)).message("Sidebar block requires a title").actualValue("No title").expectedValue("Title required").build());
            return;
        }
        if (!hasTitle) {
            return;
        }
        if (titleConfig.getMinLength() != null && title.length() < titleConfig.getMinLength()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.title.minLength").location(context.createLocation(block)).message("Sidebar title too short").actualValue(title.length() + " characters").expectedValue("At least " + titleConfig.getMinLength() + " characters").build());
        }
        if (titleConfig.getMaxLength() != null && title.length() > titleConfig.getMaxLength()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.title.maxLength").location(context.createLocation(block)).message("Sidebar title too long").actualValue(title.length() + " characters").expectedValue("At most " + titleConfig.getMaxLength() + " characters").build());
        }
        if (titleConfig.getPattern() != null && !(pattern = titleConfig.getPattern()).matcher(title).matches()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.title.pattern").location(context.createLocation(block)).message("Sidebar title does not match required pattern").actualValue(title).expectedValue("Pattern: " + pattern.pattern()).build());
        }
    }

    private void validateContent(StructuralNode block, SidebarBlock config, BlockValidationContext context, List<ValidationMessage> messages) {
        SidebarBlock.ContentConfig contentConfig = config.getContent();
        String content = this.getBlockContent(block);
        if (contentConfig.isRequired() && content.isEmpty()) {
            messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId("sidebar.content.required").location(context.createLocation(block)).message("Sidebar block requires content").actualValue("No content").expectedValue("Content required").build());
            return;
        }
        if (content.isEmpty()) {
            return;
        }
        if (contentConfig.getMinLength() != null && content.length() < contentConfig.getMinLength()) {
            messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId("sidebar.content.minLength").location(context.createLocation(block)).message("Sidebar content too short").actualValue(content.length() + " characters").expectedValue("At least " + contentConfig.getMinLength() + " characters").build());
        }
        if (contentConfig.getMaxLength() != null && content.length() > contentConfig.getMaxLength()) {
            messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId("sidebar.content.maxLength").location(context.createLocation(block)).message("Sidebar content too long").actualValue(content.length() + " characters").expectedValue("At most " + contentConfig.getMaxLength() + " characters").build());
        }
        if (contentConfig.getLines() != null) {
            this.validateLines(block, config, contentConfig.getLines(), context, messages);
        }
    }

    private void validateLines(StructuralNode block, SidebarBlock config, SidebarBlock.LinesConfig linesConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity;
        String content = this.getBlockContent(block);
        String[] lines = content.split("\n");
        int lineCount = lines.length;
        Severity severity2 = severity = linesConfig.getSeverity() != null ? linesConfig.getSeverity() : config.getSeverity();
        if (linesConfig.getMin() != null && lineCount < linesConfig.getMin()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.lines.min").location(context.createLocation(block)).message("Sidebar has too few lines").actualValue(lineCount + " lines").expectedValue("At least " + linesConfig.getMin() + " lines").build());
        }
        if (linesConfig.getMax() != null && lineCount > linesConfig.getMax()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.lines.max").location(context.createLocation(block)).message("Sidebar has too many lines").actualValue(lineCount + " lines").expectedValue("At most " + linesConfig.getMax() + " lines").build());
        }
    }

    private void validatePosition(StructuralNode block, SidebarBlock config, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity;
        SidebarBlock.PositionConfig positionConfig = config.getPosition();
        Object positionAttr = block.getAttribute((Object)"position");
        String position = positionAttr != null ? positionAttr.toString() : null;
        Severity severity2 = severity = positionConfig.getSeverity() != null ? positionConfig.getSeverity() : config.getSeverity();
        if (positionConfig.isRequired() && (position == null || position.isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.position.required").location(context.createLocation(block)).message("Sidebar block requires a position attribute").actualValue("No position attribute").expectedValue("Position attribute required").build());
            return;
        }
        if (!(position == null || position.isEmpty() || positionConfig.getAllowed() == null || positionConfig.getAllowed().isEmpty() || positionConfig.getAllowed().contains(position))) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("sidebar.position.allowed").location(context.createLocation(block)).message("Invalid sidebar position").actualValue(position).expectedValue("One of: " + String.join((CharSequence)", ", positionConfig.getAllowed())).build());
        }
    }
}

