/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.TableBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.ast.Table;

public final class TableBlockValidator
extends AbstractBlockValidator<TableBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.TABLE;
    }

    @Override
    protected Class<TableBlock> getBlockConfigClass() {
        return TableBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, TableBlock tableConfig, BlockValidationContext context) {
        if (!(block instanceof Table)) {
            return List.of();
        }
        Table table = (Table)block;
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (tableConfig.getColumns() != null) {
            this.validateColumns(table, tableConfig.getColumns(), tableConfig, context, messages);
        }
        if (tableConfig.getRows() != null) {
            this.validateRows(table, tableConfig.getRows(), tableConfig, context, messages);
        }
        if (tableConfig.getHeader() != null) {
            this.validateHeader(table, tableConfig.getHeader(), tableConfig, context, messages);
        }
        if (tableConfig.getCaption() != null) {
            this.validateCaption(table, tableConfig.getCaption(), tableConfig, context, messages);
        }
        if (tableConfig.getFormat() != null) {
            this.validateFormat(table, tableConfig.getFormat(), tableConfig, context, messages);
        }
        return messages;
    }

    private void validateColumns(Table table, TableBlock.DimensionConfig config, TableBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        int columnCount = table.getColumns().size();
        if (config.getMin() != null && columnCount < config.getMin()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("table.columns.min").location(context.createLocation((StructuralNode)table)).message("Table has too few columns").actualValue(String.valueOf(columnCount)).expectedValue("At least " + config.getMin() + " columns").build());
        }
        if (config.getMax() != null && columnCount > config.getMax()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("table.columns.max").location(context.createLocation((StructuralNode)table)).message("Table has too many columns").actualValue(String.valueOf(columnCount)).expectedValue("At most " + config.getMax() + " columns").build());
        }
    }

    private void validateRows(Table table, TableBlock.DimensionConfig config, TableBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        int rowCount = table.getBody().size();
        if (config.getMin() != null && rowCount < config.getMin()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("table.rows.min").location(context.createLocation((StructuralNode)table)).message("Table has too few rows").actualValue(String.valueOf(rowCount)).expectedValue("At least " + config.getMin() + " rows").build());
        }
        if (config.getMax() != null && rowCount > config.getMax()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("table.rows.max").location(context.createLocation((StructuralNode)table)).message("Table has too many rows").actualValue(String.valueOf(rowCount)).expectedValue("At most " + config.getMax() + " rows").build());
        }
    }

    private void validateHeader(Table table, TableBlock.HeaderConfig config, TableBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        boolean hasHeader;
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        boolean bl = hasHeader = !table.getHeader().isEmpty();
        if (config.isRequired() && !hasHeader) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("table.header.required").location(context.createLocation((StructuralNode)table)).message("Table must have a header row").actualValue("No header").expectedValue("Header row required").build());
        }
        if (hasHeader && config.getPattern() != null) {
            Pattern pattern = config.getPattern();
            for (Row headerRow : table.getHeader()) {
                for (Cell cell : headerRow.getCells()) {
                    String content = cell.getText();
                    if (pattern.matcher(content).matches()) continue;
                    messages.add(ValidationMessage.builder().severity(severity).ruleId("table.header.pattern").location(context.createLocation((StructuralNode)table)).message("Table header does not match required pattern").actualValue(content).expectedValue("Pattern: " + String.valueOf(config.getPattern())).build());
                }
            }
        }
    }

    private void validateCaption(Table table, TableBlock.CaptionConfig config, TableBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        String caption = table.getTitle();
        if (config.isRequired() && (caption == null || caption.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("table.caption.required").location(context.createLocation((StructuralNode)table)).message("Table must have a caption").actualValue("No caption").expectedValue("Caption required").build());
            return;
        }
        if (caption != null && !caption.trim().isEmpty()) {
            Pattern pattern;
            if (config.getPattern() != null && !(pattern = config.getPattern()).matcher(caption).matches()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("table.caption.pattern").location(context.createLocation((StructuralNode)table)).message("Table caption does not match required pattern").actualValue(caption).expectedValue("Pattern: " + String.valueOf(config.getPattern())).build());
            }
            if (config.getMinLength() != null && caption.length() < config.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("table.caption.minLength").location(context.createLocation((StructuralNode)table)).message("Table caption is too short").actualValue(caption.length() + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
            }
            if (config.getMaxLength() != null && caption.length() > config.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("table.caption.maxLength").location(context.createLocation((StructuralNode)table)).message("Table caption is too long").actualValue(caption.length() + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
            }
        }
    }

    private void validateFormat(Table table, TableBlock.FormatConfig config, TableBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity;
        Severity severity2 = severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        if (config.getStyle() != null) {
            String actualStyle;
            Object styleObj = table.getAttribute((Object)"options");
            String string = actualStyle = styleObj != null ? styleObj.toString() : null;
            if (actualStyle == null || !actualStyle.contains(config.getStyle())) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("table.format.style").location(context.createLocation((StructuralNode)table)).message("Table does not have required style").actualValue(actualStyle != null ? actualStyle : "default").expectedValue("Style: " + config.getStyle()).build());
            }
        }
        if (config.getBorders() != null && config.getBorders().booleanValue()) {
            String frame;
            Object frameObj = table.getAttribute((Object)"frame");
            String string = frame = frameObj != null ? frameObj.toString() : null;
            if (frame == null || "none".equals(frame)) {
                messages.add(ValidationMessage.builder().severity(severity).ruleId("table.format.borders").location(context.createLocation((StructuralNode)table)).message("Table must have borders").actualValue("No borders").expectedValue("Borders required").build());
            }
        }
    }
}

