/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.config.blocks.UlistBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class UlistBlockValidator
extends AbstractBlockValidator<UlistBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.ULIST;
    }

    @Override
    protected Class<UlistBlock> getBlockConfigClass() {
        return UlistBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, UlistBlock ulistConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        List<StructuralNode> items = this.getListItems(block);
        if (ulistConfig.getItems() != null) {
            this.validateItemsCount(items, ulistConfig.getItems(), ulistConfig, context, block, messages);
        }
        if (ulistConfig.getNestingLevel() != null) {
            this.validateNestingLevel(block, ulistConfig.getNestingLevel(), ulistConfig, context, messages);
        }
        if (ulistConfig.getMarkerStyle() != null) {
            this.validateMarkerStyle(block, ulistConfig.getMarkerStyle(), ulistConfig, context, messages);
        }
        return messages;
    }

    private List<StructuralNode> getListItems(StructuralNode block) {
        List items = block.getBlocks();
        return items != null ? items : new ArrayList();
    }

    private void validateItemsCount(List<StructuralNode> items, UlistBlock.ItemsConfig config, UlistBlock blockConfig, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages) {
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        int itemCount = items.size();
        if (config.getMin() != null && itemCount < config.getMin()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("ulist.items.min").location(context.createLocation(block)).message("Unordered list has too few items").actualValue(String.valueOf(itemCount)).expectedValue("At least " + config.getMin() + " items").build());
        }
        if (config.getMax() != null && itemCount > config.getMax()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("ulist.items.max").location(context.createLocation(block)).message("Unordered list has too many items").actualValue(String.valueOf(itemCount)).expectedValue("At most " + config.getMax() + " items").build());
        }
    }

    private void validateNestingLevel(StructuralNode block, UlistBlock.NestingLevelConfig config, UlistBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        Severity severity = config.getSeverity() != null ? config.getSeverity() : blockConfig.getSeverity();
        int nestingLevel = this.calculateNestingLevel(block);
        if (config.getMax() != null && nestingLevel > config.getMax()) {
            messages.add(ValidationMessage.builder().severity(severity).ruleId("ulist.nestingLevel.max").location(context.createLocation(block)).message("Unordered list exceeds maximum nesting level").actualValue(String.valueOf(nestingLevel)).expectedValue("Maximum nesting level: " + config.getMax()).build());
        }
    }

    private void validateMarkerStyle(StructuralNode block, String expectedMarkerStyle, UlistBlock blockConfig, BlockValidationContext context, List<ValidationMessage> messages) {
        String actualMarkerStyle = this.getMarkerStyle(block);
        if (actualMarkerStyle != null && !actualMarkerStyle.equals(expectedMarkerStyle)) {
            messages.add(ValidationMessage.builder().severity(blockConfig.getSeverity()).ruleId("ulist.markerStyle").location(context.createLocation(block)).message("Unordered list uses incorrect marker style").actualValue(actualMarkerStyle).expectedValue(expectedMarkerStyle).build());
        }
    }

    private int calculateNestingLevel(StructuralNode block) {
        int level = 0;
        StructuralNode parent = null;
        if (block.getParent() instanceof StructuralNode) {
            parent = (StructuralNode)block.getParent();
        }
        while (parent != null) {
            if ("ulist".equals(parent.getContext()) || "olist".equals(parent.getContext())) {
                ++level;
            }
            if (parent.getParent() instanceof StructuralNode) {
                parent = (StructuralNode)parent.getParent();
                continue;
            }
            parent = null;
        }
        return level;
    }

    private String getMarkerStyle(StructuralNode block) {
        Object marker = block.getAttribute((Object)"marker");
        if (marker != null) {
            return marker.toString();
        }
        String style = block.getStyle();
        if (style != null) {
            return style;
        }
        return "*";
    }
}

