/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.block;

import com.dataliquid.asciidoc.linter.config.BlockType;
import com.dataliquid.asciidoc.linter.config.blocks.VerseBlock;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.block.AbstractBlockValidator;
import com.dataliquid.asciidoc.linter.validator.block.BlockValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.ast.StructuralNode;

public final class VerseBlockValidator
extends AbstractBlockValidator<VerseBlock> {
    @Override
    public BlockType getSupportedType() {
        return BlockType.VERSE;
    }

    @Override
    protected Class<VerseBlock> getBlockConfigClass() {
        return VerseBlock.class;
    }

    @Override
    protected List<ValidationMessage> performSpecificValidations(StructuralNode block, VerseBlock verseConfig, BlockValidationContext context) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        String author = this.getAuthor(block);
        String attribution = this.getAttribution(block);
        String content = this.getBlockContent(block);
        if (verseConfig.getAuthor() != null) {
            this.validateAuthor(author, verseConfig.getAuthor(), context, block, messages, verseConfig);
        }
        if (verseConfig.getAttribution() != null) {
            this.validateAttribution(attribution, verseConfig.getAttribution(), context, block, messages, verseConfig);
        }
        if (verseConfig.getContent() != null) {
            this.validateContent(content, verseConfig.getContent(), context, block, messages, verseConfig);
        }
        return messages;
    }

    private String getAuthor(StructuralNode block) {
        Object attr = block.getAttribute((Object)"author");
        if (attr != null) {
            return attr.toString();
        }
        return null;
    }

    private String getAttribution(StructuralNode block) {
        Object attr = block.getAttribute((Object)"attribution");
        if (attr != null) {
            return attr.toString();
        }
        attr = block.getAttribute((Object)"citetitle");
        if (attr != null) {
            return attr.toString();
        }
        return null;
    }

    private void validateAuthor(String author, VerseBlock.AuthorConfig config, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, VerseBlock verseConfig) {
        if (config.isRequired() && (author == null || author.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.author.required").location(context.createLocation(block)).message("Verse block must have an author").actualValue("No author").expectedValue("Author required").build());
            return;
        }
        if (author != null && !author.trim().isEmpty()) {
            if (config.getMinLength() != null && author.length() < config.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.author.minLength").location(context.createLocation(block)).message("Verse author is too short").actualValue(author.length() + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
            }
            if (config.getMaxLength() != null && author.length() > config.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.author.maxLength").location(context.createLocation(block)).message("Verse author is too long").actualValue(author.length() + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
            }
            if (config.getPattern() != null && !config.getPattern().matcher(author).matches()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.author.pattern").location(context.createLocation(block)).message("Verse author does not match required pattern").actualValue(author).expectedValue("Pattern: " + config.getPattern().pattern()).build());
            }
        }
    }

    private void validateAttribution(String attribution, VerseBlock.AttributionConfig config, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, VerseBlock verseConfig) {
        if (config.isRequired() && (attribution == null || attribution.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.attribution.required").location(context.createLocation(block)).message("Verse block must have an attribution").actualValue("No attribution").expectedValue("Attribution required").build());
            return;
        }
        if (attribution != null && !attribution.trim().isEmpty()) {
            if (config.getMinLength() != null && attribution.length() < config.getMinLength()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.attribution.minLength").location(context.createLocation(block)).message("Verse attribution is too short").actualValue(attribution.length() + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
            }
            if (config.getMaxLength() != null && attribution.length() > config.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.attribution.maxLength").location(context.createLocation(block)).message("Verse attribution is too long").actualValue(attribution.length() + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
            }
            if (config.getPattern() != null && !config.getPattern().matcher(attribution).matches()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.attribution.pattern").location(context.createLocation(block)).message("Verse attribution does not match required pattern").actualValue(attribution).expectedValue("Pattern: " + config.getPattern().pattern()).build());
            }
        }
    }

    private void validateContent(String content, VerseBlock.ContentConfig config, BlockValidationContext context, StructuralNode block, List<ValidationMessage> messages, VerseBlock verseConfig) {
        int contentLength;
        if (config.isRequired() && (content == null || content.trim().isEmpty())) {
            messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.content.required").location(context.createLocation(block)).message("Verse block must have content").actualValue("No content").expectedValue("Content required").build());
            return;
        }
        int n = contentLength = content != null ? content.length() : 0;
        if (config.getMinLength() != null && contentLength < config.getMinLength()) {
            messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.content.minLength").location(context.createLocation(block)).message("Verse content is too short").actualValue(contentLength + " characters").expectedValue("At least " + config.getMinLength() + " characters").build());
        }
        if (content != null) {
            if (config.getMaxLength() != null && content.length() > config.getMaxLength()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.content.maxLength").location(context.createLocation(block)).message("Verse content is too long").actualValue(content.length() + " characters").expectedValue("At most " + config.getMaxLength() + " characters").build());
            }
            if (config.getPattern() != null && !config.getPattern().matcher(content).matches()) {
                messages.add(ValidationMessage.builder().severity(verseConfig.getSeverity()).ruleId("verse.content.pattern").location(context.createLocation(block)).message("Verse content does not match required pattern").actualValue(content.substring(0, Math.min(content.length(), 50)) + "...").expectedValue("Pattern: " + config.getPattern().pattern()).build());
            }
        }
    }
}

