/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.rules;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.rules.AttributeRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class OrderRule
implements AttributeRule {
    private final Map<String, OrderConfig> orderConfigs;
    private final Map<String, AttributePosition> actualPositions = new HashMap<String, AttributePosition>();

    private OrderRule(Builder builder) {
        this.orderConfigs = Collections.unmodifiableMap(new HashMap<String, OrderConfig>(builder.orderConfigs));
    }

    @Override
    public String getRuleId() {
        return "metadata.order";
    }

    @Override
    public List<ValidationMessage> validate(String attributeName, String value, SourceLocation location) {
        this.actualPositions.put(attributeName, new AttributePosition(location, this.actualPositions.size() + 1));
        return Collections.emptyList();
    }

    @Override
    public boolean isApplicable(String attributeName) {
        return this.orderConfigs.containsKey(attributeName);
    }

    public List<ValidationMessage> validateOrder() {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (Map.Entry<String, OrderConfig> entry : this.orderConfigs.entrySet()) {
            String attrName = entry.getKey();
            OrderConfig config = entry.getValue();
            AttributePosition actual = this.actualPositions.get(attrName);
            if (actual == null || !config.hasOrder()) continue;
            for (Map.Entry<String, OrderConfig> otherEntry : this.orderConfigs.entrySet()) {
                String otherAttrName = otherEntry.getKey();
                OrderConfig otherConfig = otherEntry.getValue();
                AttributePosition otherActual = this.actualPositions.get(otherAttrName);
                if (attrName.equals(otherAttrName) || otherActual == null || !otherConfig.hasOrder() || config.getOrder() >= otherConfig.getOrder() || actual.position <= otherActual.position) continue;
                messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId(this.getRuleId()).message("Attribute '" + attrName + "' should appear before '" + otherAttrName + "': actual position line " + actual.location.getStartLine() + ", expected before line " + otherActual.location.getStartLine()).location(actual.location).attributeName(attrName).actualValue("Line " + actual.location.getStartLine()).expectedValue("Before line " + otherActual.location.getStartLine()).build());
            }
        }
        return messages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, OrderConfig> orderConfigs = new HashMap<String, OrderConfig>();

        private Builder() {
        }

        public Builder addOrderConstraint(String attributeName, Integer order, Severity severity) {
            Objects.requireNonNull(attributeName, "[" + this.getClass().getName() + "] attributeName must not be null");
            Objects.requireNonNull(severity, "[" + this.getClass().getName() + "] severity must not be null");
            this.orderConfigs.put(attributeName, new OrderConfig(order, severity));
            return this;
        }

        public OrderRule build() {
            return new OrderRule(this);
        }
    }

    private static final class AttributePosition {
        private final SourceLocation location;
        private final int position;

        AttributePosition(SourceLocation location, int position) {
            this.location = location;
            this.position = position;
        }
    }

    private static final class OrderConfig {
        private final Integer order;
        private final Severity severity;

        OrderConfig(Integer order, Severity severity) {
            this.order = order;
            this.severity = severity;
        }

        boolean hasOrder() {
            return this.order != null;
        }

        int getOrder() {
            return this.order != null ? this.order : Integer.MAX_VALUE;
        }

        Severity getSeverity() {
            return this.severity;
        }
    }
}

