/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.rules;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.rules.AttributeRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PatternRule
implements AttributeRule {
    private final Map<String, PatternConfig> patternConfigs;

    private PatternRule(Builder builder) {
        this.patternConfigs = Collections.unmodifiableMap(new HashMap<String, PatternConfig>(builder.patternConfigs));
    }

    @Override
    public String getRuleId() {
        return "metadata.pattern";
    }

    @Override
    public List<ValidationMessage> validate(String attributeName, String value, SourceLocation location) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        PatternConfig config = this.patternConfigs.get(attributeName);
        if (config != null && value != null && !value.isEmpty() && !config.getPattern().matcher(value).matches()) {
            messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId(this.getRuleId()).message("Attribute '" + attributeName + "' does not match required pattern: actual '" + value + "', expected pattern '" + config.getPatternString() + "'").location(location).attributeName(attributeName).actualValue(value).expectedValue("Pattern '" + config.getPatternString() + "'").build());
        }
        return messages;
    }

    @Override
    public boolean isApplicable(String attributeName) {
        return this.patternConfigs.containsKey(attributeName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, PatternConfig> patternConfigs = new HashMap<String, PatternConfig>();

        private Builder() {
        }

        public Builder addPattern(String attributeName, String pattern, Severity severity) {
            Objects.requireNonNull(attributeName, "[" + this.getClass().getName() + "] attributeName must not be null");
            Objects.requireNonNull(pattern, "[" + this.getClass().getName() + "] pattern must not be null");
            Objects.requireNonNull(severity, "[" + this.getClass().getName() + "] severity must not be null");
            try {
                Pattern compiledPattern = Pattern.compile(pattern);
                this.patternConfigs.put(attributeName, new PatternConfig(compiledPattern, pattern, severity));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid pattern for attribute '" + attributeName + "': " + e.getMessage());
            }
            return this;
        }

        public PatternRule build() {
            return new PatternRule(this);
        }
    }

    private static final class PatternConfig {
        private final Pattern pattern;
        private final String patternString;
        private final Severity severity;

        PatternConfig(Pattern pattern, String patternString, Severity severity) {
            this.pattern = pattern;
            this.patternString = patternString;
            this.severity = severity;
        }

        Pattern getPattern() {
            return this.pattern;
        }

        String getPatternString() {
            return this.patternString;
        }

        Severity getSeverity() {
            return this.severity;
        }
    }
}

