/*
 * Decompiled with CFR 0.152.
 */
package com.dataliquid.asciidoc.linter.validator.rules;

import com.dataliquid.asciidoc.linter.config.Severity;
import com.dataliquid.asciidoc.linter.validator.SourceLocation;
import com.dataliquid.asciidoc.linter.validator.ValidationMessage;
import com.dataliquid.asciidoc.linter.validator.rules.AttributeRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class RequiredRule
implements AttributeRule {
    private final Map<String, RequiredAttribute> requiredAttributes;

    private RequiredRule(Builder builder) {
        this.requiredAttributes = Collections.unmodifiableMap(new HashMap<String, RequiredAttribute>(builder.requiredAttributes));
    }

    @Override
    public String getRuleId() {
        return "metadata.required";
    }

    @Override
    public List<ValidationMessage> validate(String attributeName, String value, SourceLocation location) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        RequiredAttribute config = this.requiredAttributes.get(attributeName);
        if (config != null && config.isRequired() && value == null) {
            messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId(this.getRuleId()).message("Missing required attribute '" + attributeName + "'").location(location).attributeName(attributeName).actualValue(null).expectedValue("Attribute must be present").build());
        }
        return messages;
    }

    @Override
    public boolean isApplicable(String attributeName) {
        return this.requiredAttributes.containsKey(attributeName);
    }

    public List<ValidationMessage> validateMissingAttributes(Set<String> presentAttributes, SourceLocation documentLocation) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (Map.Entry<String, RequiredAttribute> entry : this.requiredAttributes.entrySet()) {
            String attrName = entry.getKey();
            RequiredAttribute config = entry.getValue();
            if (!config.isRequired() || presentAttributes.contains(attrName)) continue;
            messages.add(ValidationMessage.builder().severity(config.getSeverity()).ruleId(this.getRuleId()).message("Missing required attribute '" + attrName + "'").location(documentLocation).attributeName(attrName).actualValue(null).expectedValue("Attribute must be present").build());
        }
        return messages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, RequiredAttribute> requiredAttributes = new HashMap<String, RequiredAttribute>();

        private Builder() {
        }

        public Builder addAttribute(String name, boolean required, Severity severity) {
            Objects.requireNonNull(name, "[" + this.getClass().getName() + "] name must not be null");
            Objects.requireNonNull(severity, "[" + this.getClass().getName() + "] severity must not be null");
            this.requiredAttributes.put(name, new RequiredAttribute(required, severity));
            return this;
        }

        public RequiredRule build() {
            return new RequiredRule(this);
        }
    }

    private static final class RequiredAttribute {
        private final boolean required;
        private final Severity severity;

        RequiredAttribute(boolean required, Severity severity) {
            this.required = required;
            this.severity = severity;
        }

        boolean isRequired() {
            return this.required;
        }

        Severity getSeverity() {
            return this.severity;
        }
    }
}

