/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk;

import datameshmanager.sdk.DataMeshManagerClient;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.model.Connector;
import datameshmanager.sdk.client.model.ConnectorInfo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMeshManagerConnectorRegistration {
    private static final Logger log = LoggerFactory.getLogger(DataMeshManagerConnectorRegistration.class);
    private final DataMeshManagerClient client;
    private final String id;
    private final String type;

    public DataMeshManagerConnectorRegistration(DataMeshManagerClient client, String connectorId, String type) {
        this.client = client;
        this.id = Objects.requireNonNull(connectorId, "Connector ID is required");
        this.type = Objects.requireNonNull(type, "Connector type is required");
    }

    public void register() {
        Connector connector;
        try {
            log.debug("Checking if integration connector {} already exists", (Object)this.id);
            connector = this.client.getConnectorsApi().getConnector(this.id);
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                connector = new Connector();
            }
            throw e;
        }
        connector.id(this.id).info(new ConnectorInfo().type(this.type));
        log.info("Registering integration connector {}", (Object)this.id);
        this.client.getConnectorsApi().putConnector(this.id, connector);
    }

    public void delete() {
        log.info("Deleting integration connector {}", (Object)this.id);
        try {
            this.client.getConnectorsApi().deleteConnector(this.id);
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                log.error("Integration connector with id {} already deleted", (Object)this.id);
            }
            throw e;
        }
    }
}

