/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import datameshmanager.sdk.DataMeshManagerClient;
import datameshmanager.sdk.DataMeshManagerConnectorRegistration;
import datameshmanager.sdk.DataMeshManagerEventHandler;
import datameshmanager.sdk.DataMeshManagerStateRepository;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.model.AccessActivatedEvent;
import datameshmanager.sdk.client.model.AccessApprovedEvent;
import datameshmanager.sdk.client.model.AccessCreatedEvent;
import datameshmanager.sdk.client.model.AccessDeactivatedEvent;
import datameshmanager.sdk.client.model.AccessDeletedEvent;
import datameshmanager.sdk.client.model.AccessRejectedEvent;
import datameshmanager.sdk.client.model.AccessRequestedEvent;
import datameshmanager.sdk.client.model.AccessUpdatedEvent;
import datameshmanager.sdk.client.model.AssetCreatedEvent;
import datameshmanager.sdk.client.model.AssetDeletedEvent;
import datameshmanager.sdk.client.model.AssetUpdatedEvent;
import datameshmanager.sdk.client.model.CloudEvent;
import datameshmanager.sdk.client.model.DataContractCreatedEvent;
import datameshmanager.sdk.client.model.DataContractDeletedEvent;
import datameshmanager.sdk.client.model.DataContractUpdatedEvent;
import datameshmanager.sdk.client.model.DataProductCreatedEvent;
import datameshmanager.sdk.client.model.DataProductDeletedEvent;
import datameshmanager.sdk.client.model.DataProductUpdatedEvent;
import datameshmanager.sdk.client.model.DefinitionCreatedEvent;
import datameshmanager.sdk.client.model.DefinitionDeletedEvent;
import datameshmanager.sdk.client.model.DefinitionUpdatedEvent;
import datameshmanager.sdk.client.model.OutputPortCreatedEvent;
import datameshmanager.sdk.client.model.OutputPortDeletedEvent;
import datameshmanager.sdk.client.model.OutputPortUpdatedEvent;
import datameshmanager.sdk.client.model.SourceSystemCreatedEvent;
import datameshmanager.sdk.client.model.SourceSystemDeletedEvent;
import datameshmanager.sdk.client.model.SourceSystemUpdatedEvent;
import datameshmanager.sdk.client.model.TagCreatedEvent;
import datameshmanager.sdk.client.model.TagDeletedEvent;
import datameshmanager.sdk.client.model.TagUpdatedEvent;
import datameshmanager.sdk.client.model.TeamCreatedEvent;
import datameshmanager.sdk.client.model.TeamDeletedEvent;
import datameshmanager.sdk.client.model.TeamUpdatedEvent;
import datameshmanager.sdk.client.model.TestResultsCreatedEvent;
import datameshmanager.sdk.client.model.TestResultsDeletedEvent;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMeshManagerEventListener {
    private static final Logger log = LoggerFactory.getLogger(DataMeshManagerEventListener.class);
    private final String connectorId;
    private final DataMeshManagerEventHandler eventHandler;
    private final DataMeshManagerClient client;
    private final DataMeshManagerStateRepository stateRepository;
    private final ObjectMapper objectMapper;
    private final DataMeshManagerConnectorRegistration connectorRegistration;
    private boolean stopped = false;
    private Duration pollInterval = Duration.ofSeconds(5L);

    public DataMeshManagerEventListener(String connectorId, String type, DataMeshManagerClient client, DataMeshManagerEventHandler eventHandler, DataMeshManagerStateRepository stateRepository) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId must not be null");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler must not be null");
        this.client = Objects.requireNonNull(client, "client must not be null");
        this.stateRepository = Objects.requireNonNull(stateRepository, "stateRepository must not be null");
        this.connectorRegistration = new DataMeshManagerConnectorRegistration(client, connectorId, type);
        this.objectMapper = new ObjectMapper().findAndRegisterModules().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.connectorRegistration.register();
    }

    public void start() {
        log.info("{}: Start polling for events", (Object)this.connectorId);
        String lastEventId = this.getLastEventId();
        while (!this.stopped) {
            try {
                List<CloudEvent> events = this.fetchEvents(lastEventId);
                for (CloudEvent event : events) {
                    this.processEvent(event);
                    lastEventId = Objects.requireNonNull(event.getId()).toString();
                    this.saveLastEventId(lastEventId);
                }
                if (!events.isEmpty()) continue;
                log.info("Got empty response, now wait for {} to make the next call", (Object)this.pollInterval);
                Thread.sleep(this.pollInterval.toMillis());
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                log.error("Failed to fetch events, now wait for 30 seconds to make the next call", (Throwable)e);
                try {
                    Thread.sleep(Duration.ofSeconds(30L).toMillis());
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
        log.info("Stopped polling for events");
    }

    @Nullable
    private String getLastEventId() {
        return (String)this.stateRepository.getState().get("lastEventId");
    }

    private void saveLastEventId(String lastEventId) {
        this.stateRepository.saveState(Map.of("lastEventId", lastEventId));
    }

    public List<CloudEvent> fetchEvents(String lastEventId) throws InterruptedException {
        log.info("Fetching events with lastEventId={}", (Object)lastEventId);
        Object response = null;
        try {
            List<CloudEvent> events = this.client.getEventsApi().pollEvents(lastEventId, false);
            log.debug("Fetched {} events", (Object)events.size());
            return events;
        }
        catch (ApiException e) {
            log.error("Failed to fetch events", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.stopped) {
            log.info("Polling for events already stopped");
            return;
        }
        this.stopped = true;
        log.info("Stopping polling for events");
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
    }

    private void processEvent(CloudEvent event) {
        log.info("Processing event {} of type {}", (Object)event.getId(), (Object)event.getType());
        this.eventHandler.onEvent(event);
        switch (Objects.requireNonNull(event.getType())) {
            case "com.datamesh-manager.events.DataProductCreatedEvent": {
                this.eventHandler.onDataProductCreatedEvent(this.convertPayload(event, DataProductCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DataProductUpdatedEvent": {
                this.eventHandler.onDataProductUpdatedEvent(this.convertPayload(event, DataProductUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DataProductDeletedEvent": {
                this.eventHandler.onDataProductDeletedEvent(this.convertPayload(event, DataProductDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.OutputPortCreatedEvent": {
                this.eventHandler.onOutputPortCreatedEvent(this.convertPayload(event, OutputPortCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.OutputPortUpdatedEvent": {
                this.eventHandler.onOutputPortUpdatedEvent(this.convertPayload(event, OutputPortUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.OutputPortDeletedEvent": {
                this.eventHandler.onOutputPortDeletedEvent(this.convertPayload(event, OutputPortDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DataContractCreatedEvent": {
                this.eventHandler.onDataContractCreatedEvent(this.convertPayload(event, DataContractCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DataContractUpdatedEvent": {
                this.eventHandler.onDataContractUpdatedEvent(this.convertPayload(event, DataContractUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DataContractDeletedEvent": {
                this.eventHandler.onDataContractDeletedEvent(this.convertPayload(event, DataContractDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessCreatedEvent": {
                this.eventHandler.onAccessCreatedEvent(this.convertPayload(event, AccessCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessUpdatedEvent": {
                this.eventHandler.onAccessUpdatedEvent(this.convertPayload(event, AccessUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessDeletedEvent": {
                this.eventHandler.onAccessDeletedEvent(this.convertPayload(event, AccessDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessRequestedEvent": {
                this.eventHandler.onAccessRequestedEvent(this.convertPayload(event, AccessRequestedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessApprovedEvent": {
                this.eventHandler.onAccessApprovedEvent(this.convertPayload(event, AccessApprovedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessRejectedEvent": {
                this.eventHandler.onAccessRejectedEvent(this.convertPayload(event, AccessRejectedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessActivatedEvent": {
                this.eventHandler.onAccessActivatedEvent(this.convertPayload(event, AccessActivatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AccessDeactivatedEvent": {
                this.eventHandler.onAccessDeactivatedEvent(this.convertPayload(event, AccessDeactivatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.SourceSystemCreatedEvent": {
                this.eventHandler.onSourceSystemCreatedEvent(this.convertPayload(event, SourceSystemCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.SourceSystemUpdatedEvent": {
                this.eventHandler.onSourceSystemUpdatedEvent(this.convertPayload(event, SourceSystemUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.SourceSystemDeletedEvent": {
                this.eventHandler.onSourceSystemDeletedEvent(this.convertPayload(event, SourceSystemDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TeamCreatedEvent": {
                this.eventHandler.onTeamCreatedEvent(this.convertPayload(event, TeamCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TeamUpdatedEvent": {
                this.eventHandler.onTeamUpdatedEvent(this.convertPayload(event, TeamUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TeamDeletedEvent": {
                this.eventHandler.onTeamDeletedEvent(this.convertPayload(event, TeamDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DefinitionCreatedEvent": {
                this.eventHandler.onDefinitionCreatedEvent(this.convertPayload(event, DefinitionCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DefinitionUpdatedEvent": {
                this.eventHandler.onDefinitionUpdatedEvent(this.convertPayload(event, DefinitionUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DefinitionDeletedEvent": {
                this.eventHandler.onDefinitionDeletedEvent(this.convertPayload(event, DefinitionDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TagCreatedEvent": {
                this.eventHandler.onTagCreatedEvent(this.convertPayload(event, TagCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TagUpdatedEvent": {
                this.eventHandler.onTagUpdatedEvent(this.convertPayload(event, TagUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TagDeletedEvent": {
                this.eventHandler.onTagDeletedEvent(this.convertPayload(event, TagDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AssetCreatedEvent": {
                this.eventHandler.onAssetCreatedEvent(this.convertPayload(event, AssetCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AssetUpdatedEvent": {
                this.eventHandler.onAssetUpdatedEvent(this.convertPayload(event, AssetUpdatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.AssetDeletedEvent": {
                this.eventHandler.onAssetDeletedEvent(this.convertPayload(event, AssetDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TestResultsCreatedEvent": {
                this.eventHandler.onTestResultsCreatedEvent(this.convertPayload(event, TestResultsCreatedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.TestResultsDeletedEvent": {
                this.eventHandler.onTestResultsDeletedEvent(this.convertPayload(event, TestResultsDeletedEvent.class));
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementCreatedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementUpdatedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementDeletedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementRequestedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementApprovedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementRejectedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementActivatedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            case "com.datamesh-manager.events.DataUsageAgreementDeactivatedEvent": {
                log.debug("Ignore deprecated event");
                break;
            }
            default: {
                log.warn("Unknown event type: {}", (Object)event.getType());
            }
        }
    }

    private <T> T convertPayload(CloudEvent event, Class<T> payloadType) {
        Map<String, Object> data = event.getData();
        return (T)this.objectMapper.convertValue(data, payloadType);
    }
}

