/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk;

import datameshmanager.sdk.DataMeshManagerClient;
import datameshmanager.sdk.DataMeshManagerConnectorRegistration;
import datameshmanager.sdk.DataMeshManagerStateRepository;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.model.Connector;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMeshManagerStateRepositoryRemote
implements DataMeshManagerStateRepository {
    private static final Logger log = LoggerFactory.getLogger(DataMeshManagerConnectorRegistration.class);
    private final String connectorId;
    private final DataMeshManagerClient client;

    public DataMeshManagerStateRepositoryRemote(String connectorId, DataMeshManagerClient client) {
        this.connectorId = connectorId;
        this.client = client;
    }

    @Override
    public Map<String, Object> getState() {
        return this.client.getConnectorsApi().getConnector(this.connectorId).getState();
    }

    @Override
    public void saveState(Map<String, Object> state) {
        try {
            Connector connector = this.client.getConnectorsApi().getConnector(this.connectorId);
            connector.setState(state);
            this.client.getConnectorsApi().putConnector(this.connectorId, connector);
        }
        catch (ApiException e) {
            if (e.getCode() == 404) {
                log.error("Connector with id {} not found, please register it first", (Object)this.connectorId);
                throw e;
            }
            throw e;
        }
    }
}

