/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import datameshmanager.sdk.client.ApiClient;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.BaseApi;
import datameshmanager.sdk.client.Configuration;
import datameshmanager.sdk.client.Pair;
import datameshmanager.sdk.client.model.DataContract;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class DataContractsApi
extends BaseApi {
    public DataContractsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DataContractsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void addDataContract(@Nonnull String id, @Nonnull DataContract dataContract) throws ApiException {
        this.addDataContract(id, dataContract, Collections.emptyMap());
    }

    public void addDataContract(@Nonnull String id, @Nonnull DataContract dataContract, Map<String, String> additionalHeaders) throws ApiException {
        DataContract localVarPostBody = dataContract;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling addDataContract");
        }
        if (dataContract == null) {
            throw new ApiException(400, "Missing the required parameter 'dataContract' when calling addDataContract");
        }
        String localVarPath = "/api/datacontracts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteDataContract(@Nonnull String id) throws ApiException {
        this.deleteDataContract(id, Collections.emptyMap());
    }

    public void deleteDataContract(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteDataContract");
        }
        String localVarPath = "/api/datacontracts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public DataContract getDataContract(@Nonnull String id) throws ApiException {
        return this.getDataContract(id, Collections.emptyMap());
    }

    public DataContract getDataContract(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDataContract");
        }
        String localVarPath = "/api/datacontracts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<DataContract> localVarReturnType = new TypeReference<DataContract>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void getDataContractYaml(@Nonnull String id) throws ApiException {
        this.getDataContractYaml(id, Collections.emptyMap());
    }

    public void getDataContractYaml(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDataContractYaml");
        }
        String localVarPath = "/api/datacontracts/{id}/datacontract.yaml".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/yaml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<DataContract> getDataContracts(@Nullable String q, @Nullable String owner, @Nullable String domain, @Nullable String tag, @Nullable String sort, @Nullable Integer p) throws ApiException {
        return this.getDataContracts(q, owner, domain, tag, sort, p, Collections.emptyMap());
    }

    public List<DataContract> getDataContracts(@Nullable String q, @Nullable String owner, @Nullable String domain, @Nullable String tag, @Nullable String sort, @Nullable Integer p, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/datacontracts";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("owner", owner));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("domain", domain));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("p", p));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<List<DataContract>> localVarReturnType = new TypeReference<List<DataContract>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

