/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import datameshmanager.sdk.client.ApiClient;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.BaseApi;
import datameshmanager.sdk.client.Configuration;
import datameshmanager.sdk.client.Pair;
import datameshmanager.sdk.client.model.DataProduct;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class DataProductsApi
extends BaseApi {
    public DataProductsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public DataProductsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void addDataProduct(@Nonnull String id, @Nonnull DataProduct dataProduct) throws ApiException {
        this.addDataProduct(id, dataProduct, Collections.emptyMap());
    }

    public void addDataProduct(@Nonnull String id, @Nonnull DataProduct dataProduct, Map<String, String> additionalHeaders) throws ApiException {
        DataProduct localVarPostBody = dataProduct;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling addDataProduct");
        }
        if (dataProduct == null) {
            throw new ApiException(400, "Missing the required parameter 'dataProduct' when calling addDataProduct");
        }
        String localVarPath = "/api/dataproducts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteDataProduct(@Nonnull String id) throws ApiException {
        this.deleteDataProduct(id, Collections.emptyMap());
    }

    public void deleteDataProduct(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteDataProduct");
        }
        String localVarPath = "/api/dataproducts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public DataProduct getDataProduct(@Nonnull String id) throws ApiException {
        return this.getDataProduct(id, Collections.emptyMap());
    }

    public DataProduct getDataProduct(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getDataProduct");
        }
        String localVarPath = "/api/dataproducts/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<DataProduct> localVarReturnType = new TypeReference<DataProduct>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<DataProduct> getDataProducts(@Nullable String q, @Nullable String archetype, @Nullable String status, @Nullable String tag, @Nullable String sort, @Nullable Integer p) throws ApiException {
        return this.getDataProducts(q, archetype, status, tag, sort, p, Collections.emptyMap());
    }

    public List<DataProduct> getDataProducts(@Nullable String q, @Nullable String archetype, @Nullable String status, @Nullable String tag, @Nullable String sort, @Nullable Integer p, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/dataproducts";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("archetype", archetype));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("p", p));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<List<DataProduct>> localVarReturnType = new TypeReference<List<DataProduct>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

