/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import datameshmanager.sdk.client.ApiClient;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.BaseApi;
import datameshmanager.sdk.client.Configuration;
import datameshmanager.sdk.client.Pair;
import datameshmanager.sdk.client.model.NotificationChannel;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class NotificationChannelsApi
extends BaseApi {
    public NotificationChannelsApi() {
        super(Configuration.getDefaultApiClient());
    }

    public NotificationChannelsApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void deleteNotificationChannel(@Nonnull String teamId, @Nonnull String channelId) throws ApiException {
        this.deleteNotificationChannel(teamId, channelId, Collections.emptyMap());
    }

    public void deleteNotificationChannel(@Nonnull String teamId, @Nonnull String channelId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteNotificationChannel");
        }
        if (channelId == null) {
            throw new ApiException(400, "Missing the required parameter 'channelId' when calling deleteNotificationChannel");
        }
        String localVarPath = "/api/teams/{teamId}/notification-channels/{channelId}".replaceAll("\\{teamId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(teamId))).replaceAll("\\{channelId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(channelId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public NotificationChannel getNotificationChannel(@Nonnull String teamId, @Nonnull String channelId) throws ApiException {
        return this.getNotificationChannel(teamId, channelId, Collections.emptyMap());
    }

    public NotificationChannel getNotificationChannel(@Nonnull String teamId, @Nonnull String channelId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getNotificationChannel");
        }
        if (channelId == null) {
            throw new ApiException(400, "Missing the required parameter 'channelId' when calling getNotificationChannel");
        }
        String localVarPath = "/api/teams/{teamId}/notification-channels/{channelId}".replaceAll("\\{teamId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(teamId))).replaceAll("\\{channelId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(channelId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<NotificationChannel> localVarReturnType = new TypeReference<NotificationChannel>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void putNotificationChannel(@Nonnull String teamId, @Nonnull String channelId, @Nonnull NotificationChannel notificationChannel) throws ApiException {
        this.putNotificationChannel(teamId, channelId, notificationChannel, Collections.emptyMap());
    }

    public void putNotificationChannel(@Nonnull String teamId, @Nonnull String channelId, @Nonnull NotificationChannel notificationChannel, Map<String, String> additionalHeaders) throws ApiException {
        NotificationChannel localVarPostBody = notificationChannel;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling putNotificationChannel");
        }
        if (channelId == null) {
            throw new ApiException(400, "Missing the required parameter 'channelId' when calling putNotificationChannel");
        }
        if (notificationChannel == null) {
            throw new ApiException(400, "Missing the required parameter 'notificationChannel' when calling putNotificationChannel");
        }
        String localVarPath = "/api/teams/{teamId}/notification-channels/{channelId}".replaceAll("\\{teamId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(teamId))).replaceAll("\\{channelId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(channelId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

