/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import datameshmanager.sdk.client.ApiClient;
import datameshmanager.sdk.client.ApiException;
import datameshmanager.sdk.client.BaseApi;
import datameshmanager.sdk.client.Configuration;
import datameshmanager.sdk.client.Pair;
import datameshmanager.sdk.client.model.ScimGroup;
import datameshmanager.sdk.client.model.ScimListResponseGroups;
import datameshmanager.sdk.client.model.ScimListResponseResourceTypes;
import datameshmanager.sdk.client.model.ScimListResponseSchemas;
import datameshmanager.sdk.client.model.ScimListResponseUsers;
import datameshmanager.sdk.client.model.ScimPatchRequest;
import datameshmanager.sdk.client.model.ScimResourceType;
import datameshmanager.sdk.client.model.ScimSchema;
import datameshmanager.sdk.client.model.ScimServiceProviderConfig;
import datameshmanager.sdk.client.model.ScimUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class ScimApi
extends BaseApi {
    public ScimApi() {
        super(Configuration.getDefaultApiClient());
    }

    public ScimApi(ApiClient apiClient) {
        super(apiClient);
    }

    public ScimGroup createScimGroup(@Nonnull ScimGroup scimGroup) throws ApiException {
        return this.createScimGroup(scimGroup, Collections.emptyMap());
    }

    public ScimGroup createScimGroup(@Nonnull ScimGroup scimGroup, Map<String, String> additionalHeaders) throws ApiException {
        ScimGroup localVarPostBody = scimGroup;
        if (scimGroup == null) {
            throw new ApiException(400, "Missing the required parameter 'scimGroup' when calling createScimGroup");
        }
        String localVarPath = "/api/scim/v2/Groups";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimGroup> localVarReturnType = new TypeReference<ScimGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimUser createScimUser(@Nonnull ScimUser scimUser) throws ApiException {
        return this.createScimUser(scimUser, Collections.emptyMap());
    }

    public ScimUser createScimUser(@Nonnull ScimUser scimUser, Map<String, String> additionalHeaders) throws ApiException {
        ScimUser localVarPostBody = scimUser;
        if (scimUser == null) {
            throw new ApiException(400, "Missing the required parameter 'scimUser' when calling createScimUser");
        }
        String localVarPath = "/api/scim/v2/Users";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimUser> localVarReturnType = new TypeReference<ScimUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteScimGroup(@Nonnull String id) throws ApiException {
        this.deleteScimGroup(id, Collections.emptyMap());
    }

    public void deleteScimGroup(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteScimGroup");
        }
        String localVarPath = "/api/scim/v2/Groups/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteScimUser(@Nonnull String id) throws ApiException {
        this.deleteScimUser(id, Collections.emptyMap());
    }

    public void deleteScimUser(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteScimUser");
        }
        String localVarPath = "/api/scim/v2/Users/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ScimGroup getScimGroup(@Nonnull String id) throws ApiException {
        return this.getScimGroup(id, Collections.emptyMap());
    }

    public ScimGroup getScimGroup(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getScimGroup");
        }
        String localVarPath = "/api/scim/v2/Groups/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimGroup> localVarReturnType = new TypeReference<ScimGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimListResponseGroups getScimGroups(@Nullable Integer startIndex, @Nullable Integer count, @Nullable String filter) throws ApiException {
        return this.getScimGroups(startIndex, count, filter, Collections.emptyMap());
    }

    public ScimListResponseGroups getScimGroups(@Nullable Integer startIndex, @Nullable Integer count, @Nullable String filter, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/scim/v2/Groups";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startIndex", startIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimListResponseGroups> localVarReturnType = new TypeReference<ScimListResponseGroups>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimResourceType getScimResourceType(@Nonnull String resourceType) throws ApiException {
        return this.getScimResourceType(resourceType, Collections.emptyMap());
    }

    public ScimResourceType getScimResourceType(@Nonnull String resourceType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceType == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceType' when calling getScimResourceType");
        }
        String localVarPath = "/api/scim/v2/ResourceTypes/{resourceType}".replaceAll("\\{resourceType\\}", this.apiClient.escapeString(this.apiClient.parameterToString(resourceType)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimResourceType> localVarReturnType = new TypeReference<ScimResourceType>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimListResponseResourceTypes getScimResourceTypes() throws ApiException {
        return this.getScimResourceTypes(Collections.emptyMap());
    }

    public ScimListResponseResourceTypes getScimResourceTypes(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/scim/v2/ResourceTypes";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimListResponseResourceTypes> localVarReturnType = new TypeReference<ScimListResponseResourceTypes>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimSchema getScimSchema(@Nonnull String schemaId) throws ApiException {
        return this.getScimSchema(schemaId, Collections.emptyMap());
    }

    public ScimSchema getScimSchema(@Nonnull String schemaId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (schemaId == null) {
            throw new ApiException(400, "Missing the required parameter 'schemaId' when calling getScimSchema");
        }
        String localVarPath = "/api/scim/v2/Schemas/{schemaId}".replaceAll("\\{schemaId\\}", this.apiClient.escapeString(this.apiClient.parameterToString(schemaId)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimSchema> localVarReturnType = new TypeReference<ScimSchema>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimListResponseSchemas getScimSchemas() throws ApiException {
        return this.getScimSchemas(Collections.emptyMap());
    }

    public ScimListResponseSchemas getScimSchemas(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/scim/v2/Schemas";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimListResponseSchemas> localVarReturnType = new TypeReference<ScimListResponseSchemas>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimServiceProviderConfig getScimServiceProviderConfig() throws ApiException {
        return this.getScimServiceProviderConfig(Collections.emptyMap());
    }

    public ScimServiceProviderConfig getScimServiceProviderConfig(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/scim/v2/ServiceProviderConfig";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimServiceProviderConfig> localVarReturnType = new TypeReference<ScimServiceProviderConfig>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimUser getScimUser(@Nonnull String id) throws ApiException {
        return this.getScimUser(id, Collections.emptyMap());
    }

    public ScimUser getScimUser(@Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getScimUser");
        }
        String localVarPath = "/api/scim/v2/Users/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimUser> localVarReturnType = new TypeReference<ScimUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimListResponseUsers getScimUsers(@Nullable Integer startIndex, @Nullable Integer count, @Nullable String filter) throws ApiException {
        return this.getScimUsers(startIndex, count, filter, Collections.emptyMap());
    }

    public ScimListResponseUsers getScimUsers(@Nullable Integer startIndex, @Nullable Integer count, @Nullable String filter, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/scim/v2/Users";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startIndex", startIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimListResponseUsers> localVarReturnType = new TypeReference<ScimListResponseUsers>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimGroup replaceScimGroup(@Nonnull String id, @Nonnull ScimGroup scimGroup) throws ApiException {
        return this.replaceScimGroup(id, scimGroup, Collections.emptyMap());
    }

    public ScimGroup replaceScimGroup(@Nonnull String id, @Nonnull ScimGroup scimGroup, Map<String, String> additionalHeaders) throws ApiException {
        ScimGroup localVarPostBody = scimGroup;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling replaceScimGroup");
        }
        if (scimGroup == null) {
            throw new ApiException(400, "Missing the required parameter 'scimGroup' when calling replaceScimGroup");
        }
        String localVarPath = "/api/scim/v2/Groups/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimGroup> localVarReturnType = new TypeReference<ScimGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimUser replaceScimUser(@Nonnull String id, @Nonnull ScimUser scimUser) throws ApiException {
        return this.replaceScimUser(id, scimUser, Collections.emptyMap());
    }

    public ScimUser replaceScimUser(@Nonnull String id, @Nonnull ScimUser scimUser, Map<String, String> additionalHeaders) throws ApiException {
        ScimUser localVarPostBody = scimUser;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling replaceScimUser");
        }
        if (scimUser == null) {
            throw new ApiException(400, "Missing the required parameter 'scimUser' when calling replaceScimUser");
        }
        String localVarPath = "/api/scim/v2/Users/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimUser> localVarReturnType = new TypeReference<ScimUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimGroup updateScimGroup(@Nonnull String id, @Nonnull ScimPatchRequest scimPatchRequest) throws ApiException {
        return this.updateScimGroup(id, scimPatchRequest, Collections.emptyMap());
    }

    public ScimGroup updateScimGroup(@Nonnull String id, @Nonnull ScimPatchRequest scimPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        ScimPatchRequest localVarPostBody = scimPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateScimGroup");
        }
        if (scimPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'scimPatchRequest' when calling updateScimGroup");
        }
        String localVarPath = "/api/scim/v2/Groups/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimGroup> localVarReturnType = new TypeReference<ScimGroup>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ScimUser updateScimUser(@Nonnull String id, @Nonnull ScimPatchRequest scimPatchRequest) throws ApiException {
        return this.updateScimUser(id, scimPatchRequest, Collections.emptyMap());
    }

    public ScimUser updateScimUser(@Nonnull String id, @Nonnull ScimPatchRequest scimPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
        ScimPatchRequest localVarPostBody = scimPatchRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateScimUser");
        }
        if (scimPatchRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'scimPatchRequest' when calling updateScimUser");
        }
        String localVarPath = "/api/scim/v2/Users/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        TypeReference<ScimUser> localVarReturnType = new TypeReference<ScimUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth", "BearerAuth"};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

