/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.AccessProvider;
import datameshmanager.sdk.client.model.DataUsageAgreementConsumer;
import datameshmanager.sdk.client.model.DataUsageAgreementInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "info", "provider", "consumer", "tags", "links", "custom"})
public class Access {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_INFO = "info";
    @Nonnull
    private DataUsageAgreementInfo info;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    @Nonnull
    private AccessProvider provider;
    public static final String JSON_PROPERTY_CONSUMER = "consumer";
    @Nonnull
    private DataUsageAgreementConsumer consumer;
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_LINKS = "links";
    @Nullable
    private Map<String, String> links = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    @Nullable
    private Map<String, String> custom = new HashMap<String, String>();

    public Access id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Access info(@Nonnull DataUsageAgreementInfo info) {
        this.info = info;
        return this;
    }

    @Nonnull
    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataUsageAgreementInfo getInfo() {
        return this.info;
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInfo(@Nonnull DataUsageAgreementInfo info) {
        this.info = info;
    }

    public Access provider(@Nonnull AccessProvider provider) {
        this.provider = provider;
        return this;
    }

    @Nonnull
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AccessProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProvider(@Nonnull AccessProvider provider) {
        this.provider = provider;
    }

    public Access consumer(@Nonnull DataUsageAgreementConsumer consumer) {
        this.consumer = consumer;
        return this;
    }

    @Nonnull
    @JsonProperty(value="consumer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataUsageAgreementConsumer getConsumer() {
        return this.consumer;
    }

    @JsonProperty(value="consumer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConsumer(@Nonnull DataUsageAgreementConsumer consumer) {
        this.consumer = consumer;
    }

    public Access tags(@Nullable List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Access addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<String> tags) {
        this.tags = tags;
    }

    public Access links(@Nullable Map<String, String> links) {
        this.links = links;
        return this;
    }

    public Access putLinksItem(String key, String linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, String>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(@Nullable Map<String, String> links) {
        this.links = links;
    }

    public Access custom(@Nullable Map<String, String> custom) {
        this.custom = custom;
        return this;
    }

    public Access putCustomItem(String key, String customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, String>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustom(@Nullable Map<String, String> custom) {
        this.custom = custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Access access = (Access)o;
        return Objects.equals(this.id, access.id) && Objects.equals(this.info, access.info) && Objects.equals(this.provider, access.provider) && Objects.equals(this.consumer, access.consumer) && Objects.equals(this.tags, access.tags) && Objects.equals(this.links, access.links) && Objects.equals(this.custom, access.custom);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.provider, this.consumer, this.tags, this.links, this.custom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Access {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    consumer: ").append(this.toIndentedString(this.consumer)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInfo() != null) {
            joiner.add(this.getInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_INFO + suffix));
        }
        if (this.getProvider() != null) {
            joiner.add(this.getProvider().toUrlQueryString((String)prefix + JSON_PROPERTY_PROVIDER + suffix));
        }
        if (this.getConsumer() != null) {
            joiner.add(this.getConsumer().toUrlQueryString((String)prefix + JSON_PROPERTY_CONSUMER + suffix));
        }
        if (this.getTags() != null) {
            for (int i = 0; i < this.getTags().size(); ++i) {
                try {
                    joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTags().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLinks() != null) {
            for (String _key : this.getLinks().keySet()) {
                try {
                    joiner.add(String.format("%slinks%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getLinks().get(_key), URLEncoder.encode(String.valueOf(this.getLinks().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCustom() != null) {
            for (String _key : this.getCustom().keySet()) {
                try {
                    joiner.add(String.format("%scustom%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustom().get(_key), URLEncoder.encode(String.valueOf(this.getCustom().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

