/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.AssetColumnsInner;
import datameshmanager.sdk.client.model.AssetInfo;
import datameshmanager.sdk.client.model.AssetRelationshipsInner;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "info", "properties", "columns", "relationships", "tags", "assignedTags", "links"})
public class Asset {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_INFO = "info";
    @Nullable
    private AssetInfo info;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    @Nullable
    private Map<String, Object> properties = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    @Nullable
    private List<AssetColumnsInner> columns = new ArrayList<AssetColumnsInner>();
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    @Nullable
    private List<AssetRelationshipsInner> relationships = new ArrayList<AssetRelationshipsInner>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_ASSIGNED_TAGS = "assignedTags";
    @Nullable
    private List<String> assignedTags = new ArrayList<String>();
    public static final String JSON_PROPERTY_LINKS = "links";
    @Nullable
    private Map<String, String> links = new HashMap<String, String>();

    public Asset id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public Asset info(@Nullable AssetInfo info) {
        this.info = info;
        return this;
    }

    @Nullable
    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetInfo getInfo() {
        return this.info;
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfo(@Nullable AssetInfo info) {
        this.info = info;
    }

    public Asset properties(@Nullable Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public Asset putPropertiesItem(String key, Object propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(@Nullable Map<String, Object> properties) {
        this.properties = properties;
    }

    public Asset columns(@Nullable List<AssetColumnsInner> columns) {
        this.columns = columns;
        return this;
    }

    public Asset addColumnsItem(AssetColumnsInner columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<AssetColumnsInner>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AssetColumnsInner> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(@Nullable List<AssetColumnsInner> columns) {
        this.columns = columns;
    }

    public Asset relationships(@Nullable List<AssetRelationshipsInner> relationships) {
        this.relationships = relationships;
        return this;
    }

    public Asset addRelationshipsItem(AssetRelationshipsInner relationshipsItem) {
        if (this.relationships == null) {
            this.relationships = new ArrayList<AssetRelationshipsInner>();
        }
        this.relationships.add(relationshipsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AssetRelationshipsInner> getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelationships(@Nullable List<AssetRelationshipsInner> relationships) {
        this.relationships = relationships;
    }

    public Asset tags(@Nullable List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Asset addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<String> tags) {
        this.tags = tags;
    }

    public Asset assignedTags(@Nullable List<String> assignedTags) {
        this.assignedTags = assignedTags;
        return this;
    }

    public Asset addAssignedTagsItem(String assignedTagsItem) {
        if (this.assignedTags == null) {
            this.assignedTags = new ArrayList<String>();
        }
        this.assignedTags.add(assignedTagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assignedTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAssignedTags() {
        return this.assignedTags;
    }

    @JsonProperty(value="assignedTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignedTags(@Nullable List<String> assignedTags) {
        this.assignedTags = assignedTags;
    }

    public Asset links(@Nullable Map<String, String> links) {
        this.links = links;
        return this;
    }

    public Asset putLinksItem(String key, String linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, String>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(@Nullable Map<String, String> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Asset asset = (Asset)o;
        return Objects.equals(this.id, asset.id) && Objects.equals(this.info, asset.info) && Objects.equals(this.properties, asset.properties) && Objects.equals(this.columns, asset.columns) && Objects.equals(this.relationships, asset.relationships) && Objects.equals(this.tags, asset.tags) && Objects.equals(this.assignedTags, asset.assignedTags) && Objects.equals(this.links, asset.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.properties, this.columns, this.relationships, this.tags, this.assignedTags, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Asset {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    assignedTags: ").append(this.toIndentedString(this.assignedTags)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInfo() != null) {
            joiner.add(this.getInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_INFO + suffix));
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                try {
                    joiner.add(String.format("%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), URLEncoder.encode(String.valueOf(this.getProperties().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getColumns() != null) {
            for (int i = 0; i < this.getColumns().size(); ++i) {
                if (this.getColumns().get(i) == null) continue;
                joiner.add(this.getColumns().get(i).toUrlQueryString(String.format("%scolumns%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getRelationships() != null) {
            for (int i = 0; i < this.getRelationships().size(); ++i) {
                if (this.getRelationships().get(i) == null) continue;
                joiner.add(this.getRelationships().get(i).toUrlQueryString(String.format("%srelationships%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getTags() != null) {
            for (int i = 0; i < this.getTags().size(); ++i) {
                try {
                    joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTags().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getAssignedTags() != null) {
            for (int i = 0; i < this.getAssignedTags().size(); ++i) {
                try {
                    joiner.add(String.format("%sassignedTags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getAssignedTags().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getLinks() != null) {
            for (String _key : this.getLinks().keySet()) {
                try {
                    joiner.add(String.format("%slinks%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getLinks().get(_key), URLEncoder.encode(String.valueOf(this.getLinks().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

