/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

@JsonPropertyOrder(value={"specversion", "type", "id", "source", "subject", "time", "datacontenttype", "dataschema", "principal", "data"})
public class CloudEvent {
    public static final String JSON_PROPERTY_SPECVERSION = "specversion";
    @Nullable
    private String specversion;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private String type;
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private UUID id;
    public static final String JSON_PROPERTY_SOURCE = "source";
    @Nullable
    private URI source;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    @Nullable
    private String subject;
    public static final String JSON_PROPERTY_TIME = "time";
    @Nullable
    private OffsetDateTime time;
    public static final String JSON_PROPERTY_DATACONTENTTYPE = "datacontenttype";
    @Nullable
    private String datacontenttype;
    public static final String JSON_PROPERTY_DATASCHEMA = "dataschema";
    @Nullable
    private URI dataschema;
    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    @Nullable
    private String principal;
    public static final String JSON_PROPERTY_DATA = "data";
    @Nullable
    private Map<String, Object> data = new HashMap<String, Object>();

    public CloudEvent specversion(@Nullable String specversion) {
        this.specversion = specversion;
        return this;
    }

    @Nullable
    @JsonProperty(value="specversion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSpecversion() {
        return this.specversion;
    }

    @JsonProperty(value="specversion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSpecversion(@Nullable String specversion) {
        this.specversion = specversion;
    }

    public CloudEvent type(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable String type) {
        this.type = type;
    }

    public CloudEvent id(@Nullable UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable UUID id) {
        this.id = id;
    }

    public CloudEvent source(@Nullable URI source) {
        this.source = source;
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(@Nullable URI source) {
        this.source = source;
    }

    public CloudEvent subject(@Nullable String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(@Nullable String subject) {
        this.subject = subject;
    }

    public CloudEvent time(@Nullable OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTime() {
        return this.time;
    }

    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTime(@Nullable OffsetDateTime time) {
        this.time = time;
    }

    public CloudEvent datacontenttype(@Nullable String datacontenttype) {
        this.datacontenttype = datacontenttype;
        return this;
    }

    @Nullable
    @JsonProperty(value="datacontenttype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    @JsonProperty(value="datacontenttype")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatacontenttype(@Nullable String datacontenttype) {
        this.datacontenttype = datacontenttype;
    }

    public CloudEvent dataschema(@Nullable URI dataschema) {
        this.dataschema = dataschema;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataschema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getDataschema() {
        return this.dataschema;
    }

    @JsonProperty(value="dataschema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataschema(@Nullable URI dataschema) {
        this.dataschema = dataschema;
    }

    public CloudEvent principal(@Nullable String principal) {
        this.principal = principal;
        return this;
    }

    @Nullable
    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrincipal() {
        return this.principal;
    }

    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrincipal(@Nullable String principal) {
        this.principal = principal;
    }

    public CloudEvent data(@Nullable Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public CloudEvent putDataItem(String key, Object dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setData(@Nullable Map<String, Object> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEvent cloudEvent = (CloudEvent)o;
        return Objects.equals(this.specversion, cloudEvent.specversion) && Objects.equals(this.type, cloudEvent.type) && Objects.equals(this.id, cloudEvent.id) && Objects.equals(this.source, cloudEvent.source) && Objects.equals(this.subject, cloudEvent.subject) && Objects.equals(this.time, cloudEvent.time) && Objects.equals(this.datacontenttype, cloudEvent.datacontenttype) && Objects.equals(this.dataschema, cloudEvent.dataschema) && Objects.equals(this.principal, cloudEvent.principal) && Objects.equals(this.data, cloudEvent.data);
    }

    public int hashCode() {
        return Objects.hash(this.specversion, this.type, this.id, this.source, this.subject, this.time, this.datacontenttype, this.dataschema, this.principal, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudEvent {\n");
        sb.append("    specversion: ").append(this.toIndentedString(this.specversion)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    datacontenttype: ").append(this.toIndentedString(this.datacontenttype)).append("\n");
        sb.append("    dataschema: ").append(this.toIndentedString(this.dataschema)).append("\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSpecversion() != null) {
            try {
                joiner.add(String.format("%sspecversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSpecversion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSource() != null) {
            try {
                joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSource()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSubject() != null) {
            try {
                joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSubject()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTime() != null) {
            try {
                joiner.add(String.format("%stime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTime()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDatacontenttype() != null) {
            try {
                joiner.add(String.format("%sdatacontenttype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDatacontenttype()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDataschema() != null) {
            try {
                joiner.add(String.format("%sdataschema%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDataschema()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPrincipal() != null) {
            try {
                joiner.add(String.format("%sprincipal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrincipal()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getData() != null) {
            for (String _key : this.getData().keySet()) {
                try {
                    joiner.add(String.format("%sdata%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getData().get(_key), URLEncoder.encode(String.valueOf(this.getData().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

