/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ConnectorInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "info", "state", "custom"})
public class Connector {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_INFO = "info";
    @Nonnull
    private ConnectorInfo info;
    public static final String JSON_PROPERTY_STATE = "state";
    @Nullable
    private Map<String, Object> state = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    @Nullable
    private Map<String, Object> custom = new HashMap<String, Object>();

    public Connector id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Connector info(@Nonnull ConnectorInfo info) {
        this.info = info;
        return this;
    }

    @Nonnull
    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConnectorInfo getInfo() {
        return this.info;
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInfo(@Nonnull ConnectorInfo info) {
        this.info = info;
    }

    public Connector state(@Nullable Map<String, Object> state) {
        this.state = state;
        return this;
    }

    public Connector putStateItem(String key, Object stateItem) {
        if (this.state == null) {
            this.state = new HashMap<String, Object>();
        }
        this.state.put(key, stateItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(@Nullable Map<String, Object> state) {
        this.state = state;
    }

    public Connector custom(@Nullable Map<String, Object> custom) {
        this.custom = custom;
        return this;
    }

    public Connector putCustomItem(String key, Object customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, Object>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustom(@Nullable Map<String, Object> custom) {
        this.custom = custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connector connector = (Connector)o;
        return Objects.equals(this.id, connector.id) && Objects.equals(this.info, connector.info) && Objects.equals(this.state, connector.state) && Objects.equals(this.custom, connector.custom);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.state, this.custom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Connector {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInfo() != null) {
            joiner.add(this.getInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_INFO + suffix));
        }
        if (this.getState() != null) {
            for (String _key : this.getState().keySet()) {
                try {
                    joiner.add(String.format("%sstate%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getState().get(_key), URLEncoder.encode(String.valueOf(this.getState().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCustom() != null) {
            for (String _key : this.getCustom().keySet()) {
                try {
                    joiner.add(String.format("%scustom%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustom().get(_key), URLEncoder.encode(String.valueOf(this.getCustom().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

