/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"type", "description", "connectorVersion"})
@JsonTypeName(value="Connector_info")
public class ConnectorInfo {
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private String type;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_CONNECTOR_VERSION = "connectorVersion";
    @Nullable
    private String connectorVersion;

    public ConnectorInfo type(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable String type) {
        this.type = type;
    }

    public ConnectorInfo description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public ConnectorInfo connectorVersion(@Nullable String connectorVersion) {
        this.connectorVersion = connectorVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="connectorVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConnectorVersion() {
        return this.connectorVersion;
    }

    @JsonProperty(value="connectorVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectorVersion(@Nullable String connectorVersion) {
        this.connectorVersion = connectorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorInfo connectorInfo = (ConnectorInfo)o;
        return Objects.equals(this.type, connectorInfo.type) && Objects.equals(this.description, connectorInfo.description) && Objects.equals(this.connectorVersion, connectorInfo.connectorVersion);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.description, this.connectorVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectorInfo {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    connectorVersion: ").append(this.toIndentedString(this.connectorVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getConnectorVersion() != null) {
            try {
                joiner.add(String.format("%sconnectorVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getConnectorVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

