/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import datameshmanager.sdk.client.model.DataContractTermsPoliciesInner;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"usage", "limitations", "policies", "billing", "noticePeriod"})
@JsonTypeName(value="DataContract_terms")
public class DataContractTerms
extends HashMap<String, Object> {
    public static final String JSON_PROPERTY_USAGE = "usage";
    @Nullable
    private String usage;
    public static final String JSON_PROPERTY_LIMITATIONS = "limitations";
    @Nullable
    private String limitations;
    public static final String JSON_PROPERTY_POLICIES = "policies";
    @Nullable
    private List<DataContractTermsPoliciesInner> policies = new ArrayList<DataContractTermsPoliciesInner>();
    public static final String JSON_PROPERTY_BILLING = "billing";
    @Nullable
    private String billing;
    public static final String JSON_PROPERTY_NOTICE_PERIOD = "noticePeriod";
    @Nullable
    private String noticePeriod;

    public DataContractTerms usage(@Nullable String usage) {
        this.usage = usage;
        return this;
    }

    @Nullable
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsage() {
        return this.usage;
    }

    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsage(@Nullable String usage) {
        this.usage = usage;
    }

    public DataContractTerms limitations(@Nullable String limitations) {
        this.limitations = limitations;
        return this;
    }

    @Nullable
    @JsonProperty(value="limitations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLimitations() {
        return this.limitations;
    }

    @JsonProperty(value="limitations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimitations(@Nullable String limitations) {
        this.limitations = limitations;
    }

    public DataContractTerms policies(@Nullable List<DataContractTermsPoliciesInner> policies) {
        this.policies = policies;
        return this;
    }

    public DataContractTerms addPoliciesItem(DataContractTermsPoliciesInner policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<DataContractTermsPoliciesInner>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataContractTermsPoliciesInner> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicies(@Nullable List<DataContractTermsPoliciesInner> policies) {
        this.policies = policies;
    }

    public DataContractTerms billing(@Nullable String billing) {
        this.billing = billing;
        return this;
    }

    @Nullable
    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBilling() {
        return this.billing;
    }

    @JsonProperty(value="billing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBilling(@Nullable String billing) {
        this.billing = billing;
    }

    public DataContractTerms noticePeriod(@Nullable String noticePeriod) {
        this.noticePeriod = noticePeriod;
        return this;
    }

    @Nullable
    @JsonProperty(value="noticePeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNoticePeriod() {
        return this.noticePeriod;
    }

    @JsonProperty(value="noticePeriod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNoticePeriod(@Nullable String noticePeriod) {
        this.noticePeriod = noticePeriod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataContractTerms dataContractTerms = (DataContractTerms)o;
        return Objects.equals(this.usage, dataContractTerms.usage) && Objects.equals(this.limitations, dataContractTerms.limitations) && Objects.equals(this.policies, dataContractTerms.policies) && Objects.equals(this.billing, dataContractTerms.billing) && Objects.equals(this.noticePeriod, dataContractTerms.noticePeriod) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.usage, this.limitations, this.policies, this.billing, this.noticePeriod, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataContractTerms {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("    limitations: ").append(this.toIndentedString(this.limitations)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    billing: ").append(this.toIndentedString(this.billing)).append("\n");
        sb.append("    noticePeriod: ").append(this.toIndentedString(this.noticePeriod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUsage() != null) {
            try {
                joiner.add(String.format("%susage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUsage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLimitations() != null) {
            try {
                joiner.add(String.format("%slimitations%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLimitations()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPolicies() != null) {
            for (int i = 0; i < this.getPolicies().size(); ++i) {
                if (this.getPolicies().get(i) == null) continue;
                try {
                    joiner.add(String.format("%spolicies%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getPolicies().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getBilling() != null) {
            try {
                joiner.add(String.format("%sbilling%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBilling()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getNoticePeriod() != null) {
            try {
                joiner.add(String.format("%snoticePeriod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNoticePeriod()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

