/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.DataProductInfo;
import datameshmanager.sdk.client.model.DataProductInputPortsInner;
import datameshmanager.sdk.client.model.DataProductOutputPortsInner;
import datameshmanager.sdk.client.model.DataProductOutputPortsInnerAssetsInner;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"id", "info", "inputPorts", "outputPorts", "assets", "links", "custom", "tags"})
public class DataProduct {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_INFO = "info";
    @Nonnull
    private DataProductInfo info;
    public static final String JSON_PROPERTY_INPUT_PORTS = "inputPorts";
    @Nullable
    private List<DataProductInputPortsInner> inputPorts = new ArrayList<DataProductInputPortsInner>();
    public static final String JSON_PROPERTY_OUTPUT_PORTS = "outputPorts";
    @Nullable
    private List<DataProductOutputPortsInner> outputPorts = new ArrayList<DataProductOutputPortsInner>();
    public static final String JSON_PROPERTY_ASSETS = "assets";
    @Nullable
    private List<DataProductOutputPortsInnerAssetsInner> assets = new ArrayList<DataProductOutputPortsInnerAssetsInner>();
    public static final String JSON_PROPERTY_LINKS = "links";
    @Nullable
    private Map<String, String> links = new HashMap<String, String>();
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    @Nullable
    private Map<String, String> custom = new HashMap<String, String>();
    public static final String JSON_PROPERTY_TAGS = "tags";
    @Nullable
    private List<String> tags = new ArrayList<String>();

    public DataProduct id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public DataProduct info(@Nonnull DataProductInfo info) {
        this.info = info;
        return this;
    }

    @Nonnull
    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataProductInfo getInfo() {
        return this.info;
    }

    @JsonProperty(value="info")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInfo(@Nonnull DataProductInfo info) {
        this.info = info;
    }

    public DataProduct inputPorts(@Nullable List<DataProductInputPortsInner> inputPorts) {
        this.inputPorts = inputPorts;
        return this;
    }

    public DataProduct addInputPortsItem(DataProductInputPortsInner inputPortsItem) {
        if (this.inputPorts == null) {
            this.inputPorts = new ArrayList<DataProductInputPortsInner>();
        }
        this.inputPorts.add(inputPortsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="inputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataProductInputPortsInner> getInputPorts() {
        return this.inputPorts;
    }

    @JsonProperty(value="inputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputPorts(@Nullable List<DataProductInputPortsInner> inputPorts) {
        this.inputPorts = inputPorts;
    }

    public DataProduct outputPorts(@Nullable List<DataProductOutputPortsInner> outputPorts) {
        this.outputPorts = outputPorts;
        return this;
    }

    public DataProduct addOutputPortsItem(DataProductOutputPortsInner outputPortsItem) {
        if (this.outputPorts == null) {
            this.outputPorts = new ArrayList<DataProductOutputPortsInner>();
        }
        this.outputPorts.add(outputPortsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="outputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataProductOutputPortsInner> getOutputPorts() {
        return this.outputPorts;
    }

    @JsonProperty(value="outputPorts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputPorts(@Nullable List<DataProductOutputPortsInner> outputPorts) {
        this.outputPorts = outputPorts;
    }

    public DataProduct assets(@Nullable List<DataProductOutputPortsInnerAssetsInner> assets) {
        this.assets = assets;
        return this;
    }

    public DataProduct addAssetsItem(DataProductOutputPortsInnerAssetsInner assetsItem) {
        if (this.assets == null) {
            this.assets = new ArrayList<DataProductOutputPortsInnerAssetsInner>();
        }
        this.assets.add(assetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataProductOutputPortsInnerAssetsInner> getAssets() {
        return this.assets;
    }

    @JsonProperty(value="assets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssets(@Nullable List<DataProductOutputPortsInnerAssetsInner> assets) {
        this.assets = assets;
    }

    public DataProduct links(@Nullable Map<String, String> links) {
        this.links = links;
        return this;
    }

    public DataProduct putLinksItem(String key, String linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, String>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(@Nullable Map<String, String> links) {
        this.links = links;
    }

    public DataProduct custom(@Nullable Map<String, String> custom) {
        this.custom = custom;
        return this;
    }

    public DataProduct putCustomItem(String key, String customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, String>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustom(@Nullable Map<String, String> custom) {
        this.custom = custom;
    }

    public DataProduct tags(@Nullable List<String> tags) {
        this.tags = tags;
        return this;
    }

    public DataProduct addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(@Nullable List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataProduct dataProduct = (DataProduct)o;
        return Objects.equals(this.id, dataProduct.id) && Objects.equals(this.info, dataProduct.info) && Objects.equals(this.inputPorts, dataProduct.inputPorts) && Objects.equals(this.outputPorts, dataProduct.outputPorts) && Objects.equals(this.assets, dataProduct.assets) && Objects.equals(this.links, dataProduct.links) && Objects.equals(this.custom, dataProduct.custom) && Objects.equals(this.tags, dataProduct.tags);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.inputPorts, this.outputPorts, this.assets, this.links, this.custom, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataProduct {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("    inputPorts: ").append(this.toIndentedString(this.inputPorts)).append("\n");
        sb.append("    outputPorts: ").append(this.toIndentedString(this.outputPorts)).append("\n");
        sb.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInfo() != null) {
            joiner.add(this.getInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_INFO + suffix));
        }
        if (this.getInputPorts() != null) {
            for (i = 0; i < this.getInputPorts().size(); ++i) {
                if (this.getInputPorts().get(i) == null) continue;
                joiner.add(this.getInputPorts().get(i).toUrlQueryString(String.format("%sinputPorts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getOutputPorts() != null) {
            for (i = 0; i < this.getOutputPorts().size(); ++i) {
                if (this.getOutputPorts().get(i) == null) continue;
                joiner.add(this.getOutputPorts().get(i).toUrlQueryString(String.format("%soutputPorts%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getAssets() != null) {
            for (i = 0; i < this.getAssets().size(); ++i) {
                if (this.getAssets().get(i) == null) continue;
                joiner.add(this.getAssets().get(i).toUrlQueryString(String.format("%sassets%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getLinks() != null) {
            for (String _key : this.getLinks().keySet()) {
                try {
                    joiner.add(String.format("%slinks%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getLinks().get(_key), URLEncoder.encode(String.valueOf(this.getLinks().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCustom() != null) {
            for (String _key : this.getCustom().keySet()) {
                try {
                    joiner.add(String.format("%scustom%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustom().get(_key), URLEncoder.encode(String.valueOf(this.getCustom().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getTags() != null) {
            for (int i2 = 0; i2 < this.getTags().size(); ++i2) {
                try {
                    joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i2, containerSuffix), URLEncoder.encode(String.valueOf(this.getTags().get(i2)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

