/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"purpose", "individualAgreements", "status", "active", "startDate", "endDate", "nextReassessmentDate"})
@JsonTypeName(value="DataUsageAgreement_info")
public class DataUsageAgreementInfo {
    public static final String JSON_PROPERTY_PURPOSE = "purpose";
    @Nonnull
    private String purpose;
    public static final String JSON_PROPERTY_INDIVIDUAL_AGREEMENTS = "individualAgreements";
    @Nullable
    private String individualAgreements;
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nullable
    private StatusEnum status;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nullable
    private Boolean active;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    @Nullable
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    @Nullable
    private LocalDate endDate;
    public static final String JSON_PROPERTY_NEXT_REASSESSMENT_DATE = "nextReassessmentDate";
    @Nullable
    private LocalDate nextReassessmentDate;

    public DataUsageAgreementInfo() {
    }

    @JsonCreator
    public DataUsageAgreementInfo(@JsonProperty(value="status") StatusEnum status, @JsonProperty(value="active") Boolean active) {
        this();
        this.status = status;
        this.active = active;
    }

    public DataUsageAgreementInfo purpose(@Nonnull String purpose) {
        this.purpose = purpose;
        return this;
    }

    @Nonnull
    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPurpose() {
        return this.purpose;
    }

    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPurpose(@Nonnull String purpose) {
        this.purpose = purpose;
    }

    public DataUsageAgreementInfo individualAgreements(@Nullable String individualAgreements) {
        this.individualAgreements = individualAgreements;
        return this;
    }

    @Nullable
    @JsonProperty(value="individualAgreements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndividualAgreements() {
        return this.individualAgreements;
    }

    @JsonProperty(value="individualAgreements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividualAgreements(@Nullable String individualAgreements) {
        this.individualAgreements = individualAgreements;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @Nullable
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    public DataUsageAgreementInfo startDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
    }

    public DataUsageAgreementInfo endDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
    }

    public DataUsageAgreementInfo nextReassessmentDate(@Nullable LocalDate nextReassessmentDate) {
        this.nextReassessmentDate = nextReassessmentDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="nextReassessmentDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getNextReassessmentDate() {
        return this.nextReassessmentDate;
    }

    @JsonProperty(value="nextReassessmentDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextReassessmentDate(@Nullable LocalDate nextReassessmentDate) {
        this.nextReassessmentDate = nextReassessmentDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataUsageAgreementInfo dataUsageAgreementInfo = (DataUsageAgreementInfo)o;
        return Objects.equals(this.purpose, dataUsageAgreementInfo.purpose) && Objects.equals(this.individualAgreements, dataUsageAgreementInfo.individualAgreements) && Objects.equals((Object)this.status, (Object)dataUsageAgreementInfo.status) && Objects.equals(this.active, dataUsageAgreementInfo.active) && Objects.equals(this.startDate, dataUsageAgreementInfo.startDate) && Objects.equals(this.endDate, dataUsageAgreementInfo.endDate) && Objects.equals(this.nextReassessmentDate, dataUsageAgreementInfo.nextReassessmentDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.purpose, this.individualAgreements, this.status, this.active, this.startDate, this.endDate, this.nextReassessmentDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataUsageAgreementInfo {\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    individualAgreements: ").append(this.toIndentedString(this.individualAgreements)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    nextReassessmentDate: ").append(this.toIndentedString(this.nextReassessmentDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPurpose() != null) {
            try {
                joiner.add(String.format("%spurpose%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPurpose()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIndividualAgreements() != null) {
            try {
                joiner.add(String.format("%sindividualAgreements%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIndividualAgreements()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStatus() != null) {
            try {
                joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getActive() != null) {
            try {
                joiner.add(String.format("%sactive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getActive()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStartDate() != null) {
            try {
                joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEndDate() != null) {
            try {
                joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getNextReassessmentDate() != null) {
            try {
                joiner.add(String.format("%snextReassessmentDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getNextReassessmentDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum StatusEnum {
        REQUESTED(String.valueOf("requested")),
        APPROVED(String.valueOf("approved")),
        REJECTED(String.valueOf("rejected"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

