/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import datameshmanager.sdk.client.model.ApiSearchResource;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"query", "answer", "results", "userIntention", "searchCriteria", "sources"})
@JsonTypeName(value="getSearch_200_response")
public class GetSearch200Response {
    public static final String JSON_PROPERTY_QUERY = "query";
    @Nullable
    private String query;
    public static final String JSON_PROPERTY_ANSWER = "answer";
    @Nullable
    private String answer;
    public static final String JSON_PROPERTY_RESULTS = "results";
    @Nullable
    private List<ApiSearchResource> results = new ArrayList<ApiSearchResource>();
    public static final String JSON_PROPERTY_USER_INTENTION = "userIntention";
    @Nullable
    private Object userIntention;
    public static final String JSON_PROPERTY_SEARCH_CRITERIA = "searchCriteria";
    @Nullable
    private Object searchCriteria;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    @Nullable
    private List<ApiSearchResource> sources = new ArrayList<ApiSearchResource>();

    public GetSearch200Response query(@Nullable String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(@Nullable String query) {
        this.query = query;
    }

    public GetSearch200Response answer(@Nullable String answer) {
        this.answer = answer;
        return this;
    }

    @Nullable
    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnswer() {
        return this.answer;
    }

    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(@Nullable String answer) {
        this.answer = answer;
    }

    public GetSearch200Response results(@Nullable List<ApiSearchResource> results) {
        this.results = results;
        return this;
    }

    public GetSearch200Response addResultsItem(ApiSearchResource resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<ApiSearchResource>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApiSearchResource> getResults() {
        return this.results;
    }

    @JsonProperty(value="results")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResults(@Nullable List<ApiSearchResource> results) {
        this.results = results;
    }

    public GetSearch200Response userIntention(@Nullable Object userIntention) {
        this.userIntention = userIntention;
        return this;
    }

    @Nullable
    @JsonProperty(value="userIntention")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getUserIntention() {
        return this.userIntention;
    }

    @JsonProperty(value="userIntention")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserIntention(@Nullable Object userIntention) {
        this.userIntention = userIntention;
    }

    public GetSearch200Response searchCriteria(@Nullable Object searchCriteria) {
        this.searchCriteria = searchCriteria;
        return this;
    }

    @Nullable
    @JsonProperty(value="searchCriteria")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSearchCriteria() {
        return this.searchCriteria;
    }

    @JsonProperty(value="searchCriteria")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchCriteria(@Nullable Object searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public GetSearch200Response sources(@Nullable List<ApiSearchResource> sources) {
        this.sources = sources;
        return this;
    }

    public GetSearch200Response addSourcesItem(ApiSearchResource sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<ApiSearchResource>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApiSearchResource> getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSources(@Nullable List<ApiSearchResource> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSearch200Response getSearch200Response = (GetSearch200Response)o;
        return Objects.equals(this.query, getSearch200Response.query) && Objects.equals(this.answer, getSearch200Response.answer) && Objects.equals(this.results, getSearch200Response.results) && Objects.equals(this.userIntention, getSearch200Response.userIntention) && Objects.equals(this.searchCriteria, getSearch200Response.searchCriteria) && Objects.equals(this.sources, getSearch200Response.sources);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.answer, this.results, this.userIntention, this.searchCriteria, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetSearch200Response {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    userIntention: ").append(this.toIndentedString(this.userIntention)).append("\n");
        sb.append("    searchCriteria: ").append(this.toIndentedString(this.searchCriteria)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getQuery() != null) {
            try {
                joiner.add(String.format("%squery%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getQuery()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAnswer() != null) {
            try {
                joiner.add(String.format("%sanswer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAnswer()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getResults() != null) {
            for (i = 0; i < this.getResults().size(); ++i) {
                if (this.getResults().get(i) == null) continue;
                joiner.add(this.getResults().get(i).toUrlQueryString(String.format("%sresults%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getUserIntention() != null) {
            try {
                joiner.add(String.format("%suserIntention%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserIntention()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSearchCriteria() != null) {
            try {
                joiner.add(String.format("%ssearchCriteria%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSearchCriteria()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSources() != null) {
            for (i = 0; i < this.getSources().size(); ++i) {
                if (this.getSources().get(i) == null) continue;
                joiner.add(this.getSources().get(i).toUrlQueryString(String.format("%ssources%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

