/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import datameshmanager.sdk.client.model.Field;
import datameshmanager.sdk.client.model.FieldQualityInner;
import datameshmanager.sdk.client.model.ModelConfig;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"description", "type", "title", "fields", "primaryKey", "quality", "examples", "config"})
public class Model {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private TypeEnum type = TypeEnum.TABLE;
    public static final String JSON_PROPERTY_TITLE = "title";
    @Nullable
    private String title;
    public static final String JSON_PROPERTY_FIELDS = "fields";
    @Nullable
    private Map<String, Field> fields = new HashMap<String, Field>();
    public static final String JSON_PROPERTY_PRIMARY_KEY = "primaryKey";
    @Nullable
    private List<String> primaryKey = new ArrayList<String>();
    public static final String JSON_PROPERTY_QUALITY = "quality";
    @Nullable
    private List<FieldQualityInner> quality = new ArrayList<FieldQualityInner>();
    public static final String JSON_PROPERTY_EXAMPLES = "examples";
    @Nullable
    private List<Object> examples = new ArrayList<Object>();
    public static final String JSON_PROPERTY_CONFIG = "config";
    @Nullable
    private ModelConfig config;

    public Model description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Model type(@Nullable TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable TypeEnum type) {
        this.type = type;
    }

    public Model title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public Model fields(@Nullable Map<String, Field> fields) {
        this.fields = fields;
        return this;
    }

    public Model putFieldsItem(String key, Field fieldsItem) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Field>();
        }
        this.fields.put(key, fieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Field> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFields(@Nullable Map<String, Field> fields) {
        this.fields = fields;
    }

    public Model primaryKey(@Nullable List<String> primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public Model addPrimaryKeyItem(String primaryKeyItem) {
        if (this.primaryKey == null) {
            this.primaryKey = new ArrayList<String>();
        }
        this.primaryKey.add(primaryKeyItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="primaryKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    @JsonProperty(value="primaryKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryKey(@Nullable List<String> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Model quality(@Nullable List<FieldQualityInner> quality) {
        this.quality = quality;
        return this;
    }

    public Model addQualityItem(FieldQualityInner qualityItem) {
        if (this.quality == null) {
            this.quality = new ArrayList<FieldQualityInner>();
        }
        this.quality.add(qualityItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="quality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldQualityInner> getQuality() {
        return this.quality;
    }

    @JsonProperty(value="quality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuality(@Nullable List<FieldQualityInner> quality) {
        this.quality = quality;
    }

    public Model examples(@Nullable List<Object> examples) {
        this.examples = examples;
        return this;
    }

    public Model addExamplesItem(Object examplesItem) {
        if (this.examples == null) {
            this.examples = new ArrayList<Object>();
        }
        this.examples.add(examplesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="examples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Object> getExamples() {
        return this.examples;
    }

    @JsonProperty(value="examples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExamples(@Nullable List<Object> examples) {
        this.examples = examples;
    }

    public Model config(@Nullable ModelConfig config) {
        this.config = config;
        return this;
    }

    @Nullable
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ModelConfig getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(@Nullable ModelConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return Objects.equals(this.description, model.description) && Objects.equals((Object)this.type, (Object)model.type) && Objects.equals(this.title, model.title) && Objects.equals(this.fields, model.fields) && Objects.equals(this.primaryKey, model.primaryKey) && Objects.equals(this.quality, model.quality) && Objects.equals(this.examples, model.examples) && Objects.equals(this.config, model.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.type, this.title, this.fields, this.primaryKey, this.quality, this.examples, this.config});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Model {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    primaryKey: ").append(this.toIndentedString(this.primaryKey)).append("\n");
        sb.append("    quality: ").append(this.toIndentedString(this.quality)).append("\n");
        sb.append("    examples: ").append(this.toIndentedString(this.examples)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTitle() != null) {
            try {
                joiner.add(String.format("%stitle%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTitle()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFields() != null) {
            for (String _key : this.getFields().keySet()) {
                if (this.getFields().get(_key) == null) continue;
                joiner.add(this.getFields().get(_key).toUrlQueryString(String.format("%sfields%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getPrimaryKey() != null) {
            for (int i = 0; i < this.getPrimaryKey().size(); ++i) {
                try {
                    joiner.add(String.format("%sprimaryKey%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getPrimaryKey().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getQuality() != null) {
            for (int i = 0; i < this.getQuality().size(); ++i) {
                if (this.getQuality().get(i) == null) continue;
                joiner.add(this.getQuality().get(i).toUrlQueryString(String.format("%squality%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getExamples() != null) {
            for (int i = 0; i < this.getExamples().size(); ++i) {
                try {
                    joiner.add(String.format("%sexamples%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getExamples().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getConfig() != null) {
            try {
                joiner.add(String.format("%sconfig%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getConfig()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        TABLE(String.valueOf("table")),
        VIEW(String.valueOf("view")),
        OBJECT(String.valueOf("object"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

