/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"emailAddress", "userId", "role", "custom"})
public class OrganizationMember {
    public static final String JSON_PROPERTY_EMAIL_ADDRESS = "emailAddress";
    @Nullable
    private String emailAddress;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    @Nullable
    private String userId;
    public static final String JSON_PROPERTY_ROLE = "role";
    @Nullable
    private RoleEnum role;
    public static final String JSON_PROPERTY_CUSTOM = "custom";
    @Nullable
    private Map<String, String> custom = new HashMap<String, String>();

    public OrganizationMember() {
    }

    @JsonCreator
    public OrganizationMember(@JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="userId") String userId) {
        this();
        this.emailAddress = emailAddress;
        this.userId = userId;
    }

    @Nullable
    @JsonProperty(value="emailAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Nullable
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public OrganizationMember role(@Nullable RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(@Nullable RoleEnum role) {
        this.role = role;
    }

    public OrganizationMember custom(@Nullable Map<String, String> custom) {
        this.custom = custom;
        return this;
    }

    public OrganizationMember putCustomItem(String key, String customItem) {
        if (this.custom == null) {
            this.custom = new HashMap<String, String>();
        }
        this.custom.put(key, customItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCustom() {
        return this.custom;
    }

    @JsonProperty(value="custom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustom(@Nullable Map<String, String> custom) {
        this.custom = custom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationMember organizationMember = (OrganizationMember)o;
        return Objects.equals(this.emailAddress, organizationMember.emailAddress) && Objects.equals(this.userId, organizationMember.userId) && Objects.equals((Object)this.role, (Object)organizationMember.role) && Objects.equals(this.custom, organizationMember.custom);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.emailAddress, this.userId, this.role, this.custom});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationMember {\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getEmailAddress() != null) {
            try {
                joiner.add(String.format("%semailAddress%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEmailAddress()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUserId() != null) {
            try {
                joiner.add(String.format("%suserId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRole() != null) {
            try {
                joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getRole()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCustom() != null) {
            for (String _key : this.getCustom().keySet()) {
                try {
                    joiner.add(String.format("%scustom%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getCustom().get(_key), URLEncoder.encode(String.valueOf(this.getCustom().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }

    public static enum RoleEnum {
        MEMBER(String.valueOf("Member")),
        OWNER(String.valueOf("Owner"));

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

