/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"value", "type", "primary"})
public class ScimEmail {
    public static final String JSON_PROPERTY_VALUE = "value";
    @Nonnull
    private String value;
    public static final String JSON_PROPERTY_TYPE = "type";
    @Nullable
    private String type;
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    @Nullable
    private Boolean primary = true;

    public ScimEmail value(@Nonnull String value) {
        this.value = value;
        return this;
    }

    @Nonnull
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setValue(@Nonnull String value) {
        this.value = value;
    }

    public ScimEmail type(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(@Nullable String type) {
        this.type = type;
    }

    public ScimEmail primary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrimary() {
        return this.primary;
    }

    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimEmail scimEmail = (ScimEmail)o;
        return Objects.equals(this.value, scimEmail.value) && Objects.equals(this.type, scimEmail.type) && Objects.equals(this.primary, scimEmail.primary);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type, this.primary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimEmail {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getValue() != null) {
            try {
                joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getValue()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPrimary() != null) {
            try {
                joiner.add(String.format("%sprimary%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrimary()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

