/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimGroupMembersInner;
import datameshmanager.sdk.client.model.ScimMeta;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "id", "displayName", "members", "meta"})
public class ScimGroup {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Group"));
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    @Nonnull
    private String displayName;
    public static final String JSON_PROPERTY_MEMBERS = "members";
    @Nullable
    private List<ScimGroupMembersInner> members = new ArrayList<ScimGroupMembersInner>();
    public static final String JSON_PROPERTY_META = "meta";
    @Nullable
    private ScimMeta meta;

    public ScimGroup schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimGroup addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Group"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimGroup id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public ScimGroup displayName(@Nonnull String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayName(@Nonnull String displayName) {
        this.displayName = displayName;
    }

    public ScimGroup members(@Nullable List<ScimGroupMembersInner> members) {
        this.members = members;
        return this;
    }

    public ScimGroup addMembersItem(ScimGroupMembersInner membersItem) {
        if (this.members == null) {
            this.members = new ArrayList<ScimGroupMembersInner>();
        }
        this.members.add(membersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScimGroupMembersInner> getMembers() {
        return this.members;
    }

    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMembers(@Nullable List<ScimGroupMembersInner> members) {
        this.members = members;
    }

    public ScimGroup meta(@Nullable ScimMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimMeta getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(@Nullable ScimMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimGroup scimGroup = (ScimGroup)o;
        return Objects.equals(this.schemas, scimGroup.schemas) && Objects.equals(this.id, scimGroup.id) && Objects.equals(this.displayName, scimGroup.displayName) && Objects.equals(this.members, scimGroup.members) && Objects.equals(this.meta, scimGroup.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.id, this.displayName, this.members, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimGroup {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDisplayName() != null) {
            try {
                joiner.add(String.format("%sdisplayName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDisplayName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMembers() != null) {
            for (i = 0; i < this.getMembers().size(); ++i) {
                if (this.getMembers().get(i) == null) continue;
                joiner.add(this.getMembers().get(i).toUrlQueryString(String.format("%smembers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMeta() != null) {
            joiner.add(this.getMeta().toUrlQueryString((String)prefix + JSON_PROPERTY_META + suffix));
        }
        return joiner.toString();
    }
}

