/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"totalResults", "itemsPerPage", "startIndex", "schemas"})
public class ScimListResponse {
    public static final String JSON_PROPERTY_TOTAL_RESULTS = "totalResults";
    @Nullable
    private Integer totalResults;
    public static final String JSON_PROPERTY_ITEMS_PER_PAGE = "itemsPerPage";
    @Nullable
    private Integer itemsPerPage;
    public static final String JSON_PROPERTY_START_INDEX = "startIndex";
    @Nullable
    private Integer startIndex;
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:ListResponse"));

    public ScimListResponse totalResults(@Nullable Integer totalResults) {
        this.totalResults = totalResults;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @JsonProperty(value="totalResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalResults(@Nullable Integer totalResults) {
        this.totalResults = totalResults;
    }

    public ScimListResponse itemsPerPage(@Nullable Integer itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        return this;
    }

    @Nullable
    @JsonProperty(value="itemsPerPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @JsonProperty(value="itemsPerPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemsPerPage(@Nullable Integer itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public ScimListResponse startIndex(@Nullable Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="startIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @JsonProperty(value="startIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartIndex(@Nullable Integer startIndex) {
        this.startIndex = startIndex;
    }

    public ScimListResponse schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimListResponse addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:ListResponse"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimListResponse scimListResponse = (ScimListResponse)o;
        return Objects.equals(this.totalResults, scimListResponse.totalResults) && Objects.equals(this.itemsPerPage, scimListResponse.itemsPerPage) && Objects.equals(this.startIndex, scimListResponse.startIndex) && Objects.equals(this.schemas, scimListResponse.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.totalResults, this.itemsPerPage, this.startIndex, this.schemas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimListResponse {\n");
        sb.append("    totalResults: ").append(this.toIndentedString(this.totalResults)).append("\n");
        sb.append("    itemsPerPage: ").append(this.toIndentedString(this.itemsPerPage)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTotalResults() != null) {
            try {
                joiner.add(String.format("%stotalResults%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotalResults()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getItemsPerPage() != null) {
            try {
                joiner.add(String.format("%sitemsPerPage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getItemsPerPage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStartIndex() != null) {
            try {
                joiner.add(String.format("%sstartIndex%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartIndex()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchemas() != null) {
            for (int i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

