/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimResourceType;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"totalResults", "itemsPerPage", "startIndex", "schemas", "Resources"})
public class ScimListResponseResourceTypes {
    public static final String JSON_PROPERTY_TOTAL_RESULTS = "totalResults";
    @Nullable
    private Integer totalResults;
    public static final String JSON_PROPERTY_ITEMS_PER_PAGE = "itemsPerPage";
    @Nullable
    private Integer itemsPerPage;
    public static final String JSON_PROPERTY_START_INDEX = "startIndex";
    @Nullable
    private Integer startIndex;
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:ListResponse"));
    public static final String JSON_PROPERTY_RESOURCES = "Resources";
    @Nullable
    private List<ScimResourceType> resources = new ArrayList<ScimResourceType>();

    public ScimListResponseResourceTypes totalResults(@Nullable Integer totalResults) {
        this.totalResults = totalResults;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @JsonProperty(value="totalResults")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalResults(@Nullable Integer totalResults) {
        this.totalResults = totalResults;
    }

    public ScimListResponseResourceTypes itemsPerPage(@Nullable Integer itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        return this;
    }

    @Nullable
    @JsonProperty(value="itemsPerPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @JsonProperty(value="itemsPerPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemsPerPage(@Nullable Integer itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public ScimListResponseResourceTypes startIndex(@Nullable Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="startIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @JsonProperty(value="startIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartIndex(@Nullable Integer startIndex) {
        this.startIndex = startIndex;
    }

    public ScimListResponseResourceTypes schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimListResponseResourceTypes addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:ListResponse"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimListResponseResourceTypes resources(@Nullable List<ScimResourceType> resources) {
        this.resources = resources;
        return this;
    }

    public ScimListResponseResourceTypes addResourcesItem(ScimResourceType resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<ScimResourceType>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="Resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScimResourceType> getResources() {
        return this.resources;
    }

    @JsonProperty(value="Resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResources(@Nullable List<ScimResourceType> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimListResponseResourceTypes scimListResponseResourceTypes = (ScimListResponseResourceTypes)o;
        return Objects.equals(this.totalResults, scimListResponseResourceTypes.totalResults) && Objects.equals(this.itemsPerPage, scimListResponseResourceTypes.itemsPerPage) && Objects.equals(this.startIndex, scimListResponseResourceTypes.startIndex) && Objects.equals(this.schemas, scimListResponseResourceTypes.schemas) && Objects.equals(this.resources, scimListResponseResourceTypes.resources);
    }

    public int hashCode() {
        return Objects.hash(this.totalResults, this.itemsPerPage, this.startIndex, this.schemas, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimListResponseResourceTypes {\n");
        sb.append("    totalResults: ").append(this.toIndentedString(this.totalResults)).append("\n");
        sb.append("    itemsPerPage: ").append(this.toIndentedString(this.itemsPerPage)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTotalResults() != null) {
            try {
                joiner.add(String.format("%stotalResults%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTotalResults()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getItemsPerPage() != null) {
            try {
                joiner.add(String.format("%sitemsPerPage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getItemsPerPage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStartIndex() != null) {
            try {
                joiner.add(String.format("%sstartIndex%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartIndex()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getResources() != null) {
            for (i = 0; i < this.getResources().size(); ++i) {
                if (this.getResources().get(i) == null) continue;
                joiner.add(this.getResources().get(i).toUrlQueryString(String.format("%sResources%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

