/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"resourceType", "created", "lastModified", "location", "version"})
public class ScimMeta {
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    @Nullable
    private String resourceType = "User";
    public static final String JSON_PROPERTY_CREATED = "created";
    @Nullable
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_LAST_MODIFIED = "lastModified";
    @Nullable
    private OffsetDateTime lastModified;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nullable
    private String location;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private String version;

    public ScimMeta resourceType(@Nullable String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(@Nullable String resourceType) {
        this.resourceType = resourceType;
    }

    public ScimMeta created(@Nullable OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(@Nullable OffsetDateTime created) {
        this.created = created;
    }

    public ScimMeta lastModified(@Nullable OffsetDateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    @JsonProperty(value="lastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty(value="lastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastModified(@Nullable OffsetDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public ScimMeta location(@Nullable String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(@Nullable String location) {
        this.location = location;
    }

    public ScimMeta version(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimMeta scimMeta = (ScimMeta)o;
        return Objects.equals(this.resourceType, scimMeta.resourceType) && Objects.equals(this.created, scimMeta.created) && Objects.equals(this.lastModified, scimMeta.lastModified) && Objects.equals(this.location, scimMeta.location) && Objects.equals(this.version, scimMeta.version);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.created, this.lastModified, this.location, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimMeta {\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getResourceType() != null) {
            try {
                joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCreated() != null) {
            try {
                joiner.add(String.format("%screated%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreated()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLastModified() != null) {
            try {
                joiner.add(String.format("%slastModified%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLastModified()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLocation() != null) {
            try {
                joiner.add(String.format("%slocation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLocation()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

