/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimPatchRequestOperationsInner;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "operations"})
public class ScimPatchRequest {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:PatchOp"));
    public static final String JSON_PROPERTY_OPERATIONS = "operations";
    @Nonnull
    private List<ScimPatchRequestOperationsInner> operations = new ArrayList<ScimPatchRequestOperationsInner>();

    public ScimPatchRequest schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimPatchRequest addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:PatchOp"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimPatchRequest operations(@Nonnull List<ScimPatchRequestOperationsInner> operations) {
        this.operations = operations;
        return this;
    }

    public ScimPatchRequest addOperationsItem(ScimPatchRequestOperationsInner operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<ScimPatchRequestOperationsInner>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ScimPatchRequestOperationsInner> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOperations(@Nonnull List<ScimPatchRequestOperationsInner> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimPatchRequest scimPatchRequest = (ScimPatchRequest)o;
        return Objects.equals(this.schemas, scimPatchRequest.schemas) && Objects.equals(this.operations, scimPatchRequest.operations);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.operations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimPatchRequest {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getOperations() != null) {
            for (i = 0; i < this.getOperations().size(); ++i) {
                if (this.getOperations().get(i) == null) continue;
                joiner.add(this.getOperations().get(i).toUrlQueryString(String.format("%soperations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

