/*
 * Decompiled with CFR 0.152.
 */
package datameshmanager.sdk.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import datameshmanager.sdk.client.model.ScimMeta;
import datameshmanager.sdk.client.model.ScimSchemaExtension;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "id", "name", "description", "endpoint", "schema", "schemaExtensions", "meta"})
public class ScimResourceType {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    @Nullable
    private List<String> schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ResourceType"));
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nullable
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_ENDPOINT = "endpoint";
    @Nullable
    private String endpoint;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    @Nullable
    private String schema;
    public static final String JSON_PROPERTY_SCHEMA_EXTENSIONS = "schemaExtensions";
    @Nullable
    private List<ScimSchemaExtension> schemaExtensions = new ArrayList<ScimSchemaExtension>();
    public static final String JSON_PROPERTY_META = "meta";
    @Nullable
    private ScimMeta meta;

    public ScimResourceType schemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ScimResourceType addSchemasItem(String schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ResourceType"));
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(@Nullable List<String> schemas) {
        this.schemas = schemas;
    }

    public ScimResourceType id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable String id) {
        this.id = id;
    }

    public ScimResourceType name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(@Nullable String name) {
        this.name = name;
    }

    public ScimResourceType description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public ScimResourceType endpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nullable
    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    public ScimResourceType schema(@Nullable String schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(@Nullable String schema) {
        this.schema = schema;
    }

    public ScimResourceType schemaExtensions(@Nullable List<ScimSchemaExtension> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
        return this;
    }

    public ScimResourceType addSchemaExtensionsItem(ScimSchemaExtension schemaExtensionsItem) {
        if (this.schemaExtensions == null) {
            this.schemaExtensions = new ArrayList<ScimSchemaExtension>();
        }
        this.schemaExtensions.add(schemaExtensionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemaExtensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScimSchemaExtension> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    @JsonProperty(value="schemaExtensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaExtensions(@Nullable List<ScimSchemaExtension> schemaExtensions) {
        this.schemaExtensions = schemaExtensions;
    }

    public ScimResourceType meta(@Nullable ScimMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScimMeta getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeta(@Nullable ScimMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimResourceType scimResourceType = (ScimResourceType)o;
        return Objects.equals(this.schemas, scimResourceType.schemas) && Objects.equals(this.id, scimResourceType.id) && Objects.equals(this.name, scimResourceType.name) && Objects.equals(this.description, scimResourceType.description) && Objects.equals(this.endpoint, scimResourceType.endpoint) && Objects.equals(this.schema, scimResourceType.schema) && Objects.equals(this.schemaExtensions, scimResourceType.schemaExtensions) && Objects.equals(this.meta, scimResourceType.meta);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.id, this.name, this.description, this.endpoint, this.schema, this.schemaExtensions, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimResourceType {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    schemaExtensions: ").append(this.toIndentedString(this.schemaExtensions)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (i = 0; i < this.getSchemas().size(); ++i) {
                try {
                    joiner.add(String.format("%sschemas%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getSchemas().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEndpoint() != null) {
            try {
                joiner.add(String.format("%sendpoint%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndpoint()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchema() != null) {
            try {
                joiner.add(String.format("%sschema%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSchema()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSchemaExtensions() != null) {
            for (i = 0; i < this.getSchemaExtensions().size(); ++i) {
                if (this.getSchemaExtensions().get(i) == null) continue;
                joiner.add(this.getSchemaExtensions().get(i).toUrlQueryString(String.format("%sschemaExtensions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getMeta() != null) {
            joiner.add(this.getMeta().toUrlQueryString((String)prefix + JSON_PROPERTY_META + suffix));
        }
        return joiner.toString();
    }
}

